/*
 * Decompiled with CFR 0.152.
 */
package dataframe;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class Bfrm {
    String DataFile = "";
    String HFile = "";
    String WeightFile = "";
    String ResponseMaskFile = "";
    String EvolVarInFile = "";
    String XMaskFile = "";
    int Wishart = 0;
    int WishartT0 = 1;
    int Evol = 0;
    int EvolVarIn = 0;
    int EvolMiniumVariablesInFactor = 5;
    double EvolIncludeFactorThreshold = 0.7;
    int EvolMaximumVariables = 1000;
    int EvolMaximumFactors = 50;
    double EvolIncludeVariableThreshold = 0.95;
    int EvolMaximumVariablesPerIteration = 25;
    int InclusionMethod = 1;
    int NonGaussianFactors = 1;
    int NObservations = 0;
    int NVariables = 0;
    int NLatentFactors = 0;
    int NDesignVariables = 1;
    int NBinaryResponses = 0;
    int NCategoricalResponses = 0;
    int NSurvivalResponses = 0;
    int NContinuousResponses = 0;
    int burnin = 2000;
    int nmcSamples = 5000;
    int burnin_select = 1000;
    int nmcSamples_select = 2000;
    int noisy = 100;
    int ShapeOfB = 0;
    int PriorPiStandard;
    int NControlVariables;
    double PriorRhoN;
    double PriorRhoMean;
    double PriorPiN;
    double PriorPiMean;
    double[] PriorPsi = new double[2];
    double[] PriorSurvivalPsi = new double[2];
    double[] PriorTauDesign = new double[2];
    double[][] PriorTauResponse = new double[4][2];
    double[] PriorTauLatent = new double[2];
    double PriorInterceptMean = 8.0;
    double PriorSurvivalMean = 4.0;
    double PriorContinuousMean = 0.0;
    double PriorInterceptVar = 100.0;
    double PriorSurvivalVar = 1.0;
    double PriorContinuousVar = 1.0;
    double alpha;
    double alphax;
    double PriorAlphaA;
    double PriorAlphaB;

    public Bfrm() {
        this.PriorPsi[0] = 10.0;
        this.PriorPsi[1] = 2.0;
        this.PriorSurvivalPsi[0] = 2.0;
        this.PriorSurvivalPsi[1] = 0.5;
        this.PriorRhoMean = 0.001;
        this.PriorRhoN = 200.0;
        this.PriorPiMean = 0.9;
        this.PriorPiN = 10.0;
        this.PriorPiStandard = 1;
        this.NControlVariables = 0;
        this.PriorTauDesign[0] = 5.0;
        this.PriorTauDesign[1] = 1.0;
        for (int i = 0; i < 4; ++i) {
            this.PriorTauResponse[i][0] = 5.0;
            this.PriorTauResponse[i][1] = 1.0;
        }
        this.PriorTauLatent[0] = 5.0;
        this.PriorTauLatent[1] = 1.0;
        this.alpha = 1.0;
        this.alphax = 0.5;
        this.PriorAlphaA = 1.0;
        this.PriorAlphaB = 1.0;
    }

    public void setData(String DataFileName, int nVariables, int nObservations) {
        this.DataFile = DataFileName;
        this.NObservations = nObservations;
        this.NVariables = nVariables;
    }

    public void setDesignControlFactors(String DesignControlFileName, int nDesignFactors, int nControlFactors) {
        this.HFile = DesignControlFileName;
        this.NDesignVariables = nDesignFactors;
        this.NControlVariables = nControlFactors;
    }

    public void setLatentFactors(int nLatentFactors) {
        this.NLatentFactors = nLatentFactors;
    }

    public void setEvol(int flag, int IntialVariables) {
        this.Evol = flag;
        this.EvolVarIn = IntialVariables;
        this.EvolVarInFile = "";
    }

    public void setWishart(int flag, int t0) {
        this.Wishart = flag;
        this.WishartT0 = t0;
    }

    public void setNonGaussianFactors(int val) {
        this.NonGaussianFactors = val;
    }

    public void setInclusionMethod(int val) {
        this.InclusionMethod = val;
    }

    public void setEvol(int flag, int IntialVariables, String EvolFile) {
        this.Evol = flag;
        this.EvolVarIn = IntialVariables;
        this.EvolVarInFile = EvolFile;
    }

    public void setEvolThresholds(double IncludeVariable, double IncludeFactor, int MinVarInFactor, int MaxVar, int MaxFactor, int MaxVarPerIter) {
        this.EvolMiniumVariablesInFactor = MinVarInFactor;
        this.EvolIncludeFactorThreshold = IncludeFactor;
        this.EvolIncludeVariableThreshold = IncludeVariable;
        this.EvolMaximumVariables = MaxVar;
        this.EvolMaximumFactors = MaxFactor;
        this.EvolMaximumVariablesPerIteration = MaxVarPerIter;
    }

    public void setResponseFactors(int nBinary, int nCategorical, int nSurvival, int nContinuous) {
        this.NBinaryResponses = nBinary;
        this.NCategoricalResponses = nCategorical;
        this.NSurvivalResponses = nSurvival;
        this.NContinuousResponses = nContinuous;
    }

    public void setResponseMask(String MaskFileName) {
        this.ResponseMaskFile = MaskFileName;
    }

    public void setXMask(String MaskFileName) {
        this.XMaskFile = MaskFileName;
    }

    public void setPriorInterceptMeanVar(double mean, double variance) {
        this.PriorInterceptMean = mean;
        this.PriorInterceptVar = variance;
    }

    public void setPriorSurvivalMeanVar(double mean, double variance) {
        this.PriorSurvivalMean = mean;
        this.PriorSurvivalVar = variance;
    }

    public void setPriorContinuousMeanVar(double mean, double variance) {
        this.PriorContinuousMean = mean;
        this.PriorContinuousVar = variance;
    }

    public void setPriorPsiSurvival(double a, double b) {
        this.PriorSurvivalPsi[0] = a;
        this.PriorSurvivalPsi[1] = b;
    }

    public void setPriorPsiContinuous(double a, double b) {
        System.out.println("setPriorPsiContinuous::To be done");
    }

    public void setPriorPsi(double a, double b) {
        this.PriorPsi[0] = a;
        this.PriorPsi[1] = b;
    }

    public void setPriorRho(double mean, double N) {
        this.PriorRhoMean = mean;
        this.PriorRhoN = N;
    }

    public void setPriorDPAlpha(double prioralphaa, double prioralphab) {
        this.PriorAlphaA = prioralphaa;
        this.PriorAlphaB = prioralphab;
    }

    public void setPriorDPAlpha(double prioralphaa, double prioralphab, double Alpha, double AlphaX) {
        this.PriorAlphaA = prioralphaa;
        this.PriorAlphaB = prioralphab;
        this.alpha = Alpha;
        this.alphax = AlphaX;
    }

    public void setPriorPi(double mean, double N) {
        this.PriorPiMean = mean;
        this.PriorPiN = N;
    }

    public void setPriorTauDesign(double a, double b) {
        this.PriorTauDesign[0] = a;
        this.PriorTauDesign[1] = b;
    }

    public void setPriorTauResponse(double a1, double b1, double a2, double b2, double a3, double b3, double a4, double b4) {
        this.PriorTauResponse[0][0] = a1;
        this.PriorTauResponse[0][1] = b1;
        this.PriorTauResponse[1][0] = a2;
        this.PriorTauResponse[1][1] = b2;
        this.PriorTauResponse[2][0] = a3;
        this.PriorTauResponse[2][1] = b3;
        this.PriorTauResponse[3][0] = a4;
        this.PriorTauResponse[3][1] = b4;
    }

    public void setPriorTauLatent(double a, double b) {
        this.PriorTauLatent[0] = a;
        this.PriorTauLatent[1] = b;
    }

    public void setShapeOfB(int nShapeOfB) {
        this.ShapeOfB = nShapeOfB;
    }

    public void setIterations(int nBurnin, int nMC) {
        this.burnin = nBurnin;
        this.nmcSamples = nMC;
    }

    public void setEvolIterations(int nBurnin, int nMC) {
        this.burnin_select = nBurnin;
        this.nmcSamples_select = nMC;
    }

    public void setDebug(int nPrint) {
        this.noisy = nPrint;
    }

    public boolean load(String FileName) {
        if (FileName == null) {
            return true;
        }
        File f = new File(FileName);
        if (!f.exists()) {
            System.out.println("Failed to open " + FileName);
            return false;
        }
        try {
            String theLine;
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((theLine = br.readLine()) != null) {
                String Name = "";
                String Value = "";
                theLine = theLine.trim();
                if ((theLine = Bfrm.removeSpace(theLine)).length() <= 0 || theLine.startsWith("#")) continue;
                int eq = theLine.indexOf(61);
                if (eq == -1) {
                    System.out.println("Invalid line: " + theLine);
                    return false;
                }
                Name = theLine.substring(0, eq).trim();
                Value = theLine.substring(eq + 1).trim();
                String name = Name.toLowerCase();
                String value = Value.toLowerCase();
                if (name.equals("datafile")) {
                    this.DataFile = Value;
                    continue;
                }
                if (name.equals("hfile")) {
                    this.HFile = Value;
                    continue;
                }
                if (name.equals("weightfile")) {
                    this.WeightFile = Value;
                    continue;
                }
                if (name.equals("responsemaskfile")) {
                    this.ResponseMaskFile = Value;
                    continue;
                }
                if (name.equals("xmaskfile")) {
                    this.XMaskFile = Value;
                    continue;
                }
                if (name.equals("evolvarinfile")) {
                    this.EvolVarInFile = Value;
                    continue;
                }
                if (name.equals("nobservations")) {
                    this.NObservations = new Integer(value);
                    continue;
                }
                if (name.equals("evol")) {
                    this.Evol = new Integer(value);
                    continue;
                }
                if (name.equals("inversewishart")) {
                    this.Wishart = new Integer(value);
                    continue;
                }
                if (name.equals("inversewishartt0")) {
                    this.WishartT0 = new Integer(value);
                    continue;
                }
                if (name.equals("evolvarin")) {
                    this.EvolVarIn = new Integer(value);
                    continue;
                }
                if (name.equals("nongaussianfactors")) {
                    this.NonGaussianFactors = new Integer(value);
                    continue;
                }
                if (name.equals("inclusionmethod")) {
                    this.InclusionMethod = new Integer(value);
                    continue;
                }
                if (name.equals("evolminiumvariablesinfactor")) {
                    this.EvolMiniumVariablesInFactor = new Integer(value);
                    continue;
                }
                if (name.equals("evolmaximumvariables")) {
                    this.EvolMaximumVariables = new Integer(value);
                    continue;
                }
                if (name.equals("evolmaximumvariablesperiteration")) {
                    this.EvolMaximumVariablesPerIteration = new Integer(value);
                    continue;
                }
                if (name.equals("evolmaximumfactors")) {
                    this.EvolMaximumFactors = new Integer(value);
                    continue;
                }
                if (name.equals("evolincludevariablethreshold")) {
                    this.EvolIncludeVariableThreshold = new Double(value);
                    continue;
                }
                if (name.equals("evolincludefactorthreshold")) {
                    this.EvolIncludeFactorThreshold = new Double(value);
                    continue;
                }
                if (name.equals("shapeofb")) {
                    this.ShapeOfB = new Integer(value);
                    continue;
                }
                if (name.equals("nvariables")) {
                    this.NVariables = new Integer(value);
                    continue;
                }
                if (name.equals("nbinaryresponses")) {
                    this.NBinaryResponses = new Integer(value);
                    continue;
                }
                if (name.equals("ncategoricalresponses")) {
                    this.NCategoricalResponses = new Integer(value);
                    continue;
                }
                if (name.equals("nsurvivalresponses")) {
                    this.NSurvivalResponses = new Integer(value);
                    continue;
                }
                if (name.equals("ncontinuousresponses")) {
                    this.NContinuousResponses = new Integer(value);
                    continue;
                }
                if (name.equals("printiteration")) {
                    this.noisy = new Integer(value);
                    continue;
                }
                if (name.equals("nlatentfactors")) {
                    this.NLatentFactors = new Integer(value);
                    continue;
                }
                if (name.equals("ndesignvariables")) {
                    this.NDesignVariables = new Integer(value);
                    continue;
                }
                if (name.equals("ncontrolvariables")) {
                    this.NControlVariables = new Integer(value);
                    continue;
                }
                if (name.equals("priorpistandard")) {
                    this.PriorPiStandard = new Integer(value);
                    continue;
                }
                if (name.equals("burnin")) {
                    this.burnin = new Integer(value);
                    continue;
                }
                if (name.equals("burnin_select")) {
                    this.burnin_select = new Integer(value);
                    continue;
                }
                if (name.equals("priorrhomean")) {
                    this.PriorRhoMean = new Double(value);
                    continue;
                }
                if (name.equals("priorrhon")) {
                    this.PriorRhoN = new Double(value);
                    continue;
                }
                if (name.equals("priorpimean")) {
                    this.PriorPiMean = new Double(value);
                    continue;
                }
                if (name.equals("priorpin")) {
                    this.PriorPiN = new Double(value);
                    continue;
                }
                if (name.equals("priorpsia")) {
                    this.PriorPsi[0] = new Double(value);
                    continue;
                }
                if (name.equals("priorpsib")) {
                    this.PriorPsi[1] = new Double(value);
                    continue;
                }
                if (name.equals("priorsurvivalpsia")) {
                    this.PriorSurvivalPsi[0] = new Double(value);
                    continue;
                }
                if (name.equals("priorsurvivalpsib")) {
                    this.PriorSurvivalPsi[1] = new Double(value);
                    continue;
                }
                if (name.equals("priortaudesigna")) {
                    this.PriorTauDesign[0] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsebinarya")) {
                    this.PriorTauResponse[0][0] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsecategoricala")) {
                    this.PriorTauResponse[1][0] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsesurvivala")) {
                    this.PriorTauResponse[2][0] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsecontinuousa")) {
                    this.PriorTauResponse[3][0] = new Double(value);
                    continue;
                }
                if (name.equals("priortaulatenta")) {
                    this.PriorTauLatent[0] = new Double(value);
                    continue;
                }
                if (name.equals("priortaudesignb")) {
                    this.PriorTauDesign[1] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsebinaryb")) {
                    this.PriorTauResponse[0][1] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsecategoricalb")) {
                    this.PriorTauResponse[1][1] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsesurvivalb")) {
                    this.PriorTauResponse[2][1] = new Double(value);
                    continue;
                }
                if (name.equals("priortauresponsecontinuousb")) {
                    this.PriorTauResponse[3][1] = new Double(value);
                    continue;
                }
                if (name.equals("priortaulatentb")) {
                    this.PriorTauLatent[1] = new Double(value);
                    continue;
                }
                if (name.equals("priorinterceptmean")) {
                    this.PriorInterceptMean = new Double(value);
                    continue;
                }
                if (name.equals("priorinterceptvar")) {
                    this.PriorInterceptVar = new Double(value);
                    continue;
                }
                if (name.equals("priorsurvivalmean")) {
                    this.PriorSurvivalMean = new Double(value);
                    continue;
                }
                if (name.equals("priorcontinuousmean")) {
                    this.PriorContinuousMean = new Double(value);
                    continue;
                }
                if (name.equals("priorsurvivalvar")) {
                    this.PriorSurvivalVar = new Double(value);
                    continue;
                }
                if (name.equals("priorcontinuousvar")) {
                    this.PriorContinuousVar = new Double(value);
                    continue;
                }
                if (name.equals("nmcsamples")) {
                    this.nmcSamples = new Integer(value);
                    continue;
                }
                if (name.equals("nmcsamples_select")) {
                    this.nmcSamples_select = new Integer(value);
                    continue;
                }
                if (name.equals("alpha")) {
                    this.alpha = new Double(value);
                    continue;
                }
                if (name.equals("alphax")) {
                    this.alphax = new Double(value);
                    continue;
                }
                if (name.equals("prioralphaa")) {
                    this.PriorAlphaA = new Double(value);
                    continue;
                }
                if (name.equals("prioralphab")) {
                    this.PriorAlphaB = new Double(value);
                    continue;
                }
                System.out.println(theLine);
                System.out.println("The above line is not recognized!");
                return false;
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    public void save(String FileName) {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
            fw.write("#Version 2.0");
            fw.newLine();
            fw.newLine();
            fw.write("#data section");
            fw.newLine();
            fw.write("NObservations = ");
            fw.write(new Integer(this.NObservations).toString());
            fw.newLine();
            fw.write("NVariables = ");
            fw.write(new Integer(this.NVariables).toString());
            fw.newLine();
            fw.write("NBinaryResponses = ");
            fw.write(new Integer(this.NBinaryResponses).toString());
            fw.newLine();
            fw.write("NCategoricalResponses = ");
            fw.write(new Integer(this.NCategoricalResponses).toString());
            fw.newLine();
            fw.write("NSurvivalResponses = ");
            fw.write(new Integer(this.NSurvivalResponses).toString());
            fw.newLine();
            fw.write("NContinuousResponses = ");
            fw.write(new Integer(this.NContinuousResponses).toString());
            fw.newLine();
            fw.write("NDesignVariables = ");
            fw.write(new Integer(this.NDesignVariables).toString());
            fw.newLine();
            fw.write("NControlVariables = ");
            fw.write(new Integer(this.NControlVariables).toString());
            fw.newLine();
            fw.write("NLatentFactors = ");
            fw.write(new Integer(this.NLatentFactors).toString());
            fw.newLine();
            if (!this.DataFile.equals("")) {
                fw.write("DataFile = ");
                fw.write(this.DataFile);
                fw.newLine();
            } else {
                fw.write("#DataFile = ");
                fw.newLine();
            }
            if (!this.HFile.equals("")) {
                fw.write("HFile = ");
                fw.write(this.HFile);
                fw.newLine();
            } else {
                fw.write("#HFile = ");
                fw.newLine();
            }
            if (!this.ResponseMaskFile.equals("")) {
                fw.write("ResponseMaskFile = ");
                fw.write(this.ResponseMaskFile);
                fw.newLine();
            } else {
                fw.write("#ResponseMaskFile = ");
                fw.newLine();
            }
            if (!this.XMaskFile.equals("")) {
                fw.write("XMaskFile = ");
                fw.write(this.XMaskFile);
                fw.newLine();
            } else {
                fw.write("#XMaskFile = ");
                fw.newLine();
            }
            fw.newLine();
            fw.write("#prior section");
            fw.newLine();
            fw.write("#model specifiction");
            fw.newLine();
            fw.write("ShapeOfB = ");
            fw.write(new Integer(this.ShapeOfB).toString());
            fw.newLine();
            fw.write("NonGaussianFactors = ");
            fw.write(new Integer(this.NonGaussianFactors).toString());
            fw.newLine();
            fw.write("PriorPiStandard = ");
            fw.write(new Integer(this.PriorPiStandard).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#prior psi");
            fw.newLine();
            fw.write("PriorPsia = ");
            fw.write(new Double(this.PriorPsi[0]).toString());
            fw.newLine();
            fw.write("PriorPsib = ");
            fw.write(new Double(this.PriorPsi[1]).toString());
            fw.newLine();
            fw.write("PriorSurvivalPsia = ");
            fw.write(new Double(this.PriorSurvivalPsi[0]).toString());
            fw.newLine();
            fw.write("PriorSurvivalPsib = ");
            fw.write(new Double(this.PriorSurvivalPsi[1]).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#prior rho");
            fw.newLine();
            fw.write("PriorRhoMean = ");
            fw.write(new Double(this.PriorRhoMean).toString());
            fw.newLine();
            fw.write("PriorRhoN = ");
            fw.write(new Double(this.PriorRhoN).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#prior pi");
            fw.newLine();
            fw.write("PriorPiMean = ");
            fw.write(new Double(this.PriorPiMean).toString());
            fw.newLine();
            fw.write("PriorPiN = ");
            fw.write(new Double(this.PriorPiN).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#prior tau");
            fw.newLine();
            fw.write("PriorTauDesigna = ");
            fw.write(new Double(this.PriorTauDesign[0]).toString());
            fw.newLine();
            fw.write("PriorTauDesignb = ");
            fw.write(new Double(this.PriorTauDesign[1]).toString());
            fw.newLine();
            fw.newLine();
            fw.write("PriorTauResponseBinarya = ");
            fw.write(new Double(this.PriorTauResponse[0][0]).toString());
            fw.newLine();
            fw.write("PriorTauResponseBinaryb = ");
            fw.write(new Double(this.PriorTauResponse[0][1]).toString());
            fw.newLine();
            fw.newLine();
            fw.write("PriorTauResponseCategoricala = ");
            fw.write(new Double(this.PriorTauResponse[1][0]).toString());
            fw.newLine();
            fw.write("PriorTauResponseCategoricalb = ");
            fw.write(new Double(this.PriorTauResponse[1][1]).toString());
            fw.newLine();
            fw.newLine();
            fw.write("PriorTauResponseSurvivala = ");
            fw.write(new Double(this.PriorTauResponse[2][0]).toString());
            fw.newLine();
            fw.write("PriorTauResponseSurvivalb = ");
            fw.write(new Double(this.PriorTauResponse[2][1]).toString());
            fw.newLine();
            fw.newLine();
            fw.write("PriorTauResponseContinuousa = ");
            fw.write(new Double(this.PriorTauResponse[3][0]).toString());
            fw.newLine();
            fw.write("PriorTauResponseContinuousb = ");
            fw.write(new Double(this.PriorTauResponse[3][1]).toString());
            fw.newLine();
            fw.newLine();
            fw.write("PriorTauLatenta = ");
            fw.write(new Double(this.PriorTauLatent[0]).toString());
            fw.newLine();
            fw.write("PriorTauLatentb = ");
            fw.write(new Double(this.PriorTauLatent[1]).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#priors on the intercept");
            fw.newLine();
            fw.write("PriorInterceptMean = ");
            fw.write(new Double(this.PriorInterceptMean).toString());
            fw.newLine();
            fw.write("PriorSurvivalMean = ");
            fw.write(new Double(this.PriorSurvivalMean).toString());
            fw.newLine();
            fw.write("PriorContinuousMean = ");
            fw.write(new Double(this.PriorContinuousMean).toString());
            fw.newLine();
            fw.write("PriorInterceptVar = ");
            fw.write(new Double(this.PriorInterceptVar).toString());
            fw.newLine();
            fw.write("PriorSurvivalVar = ");
            fw.write(new Double(this.PriorSurvivalVar).toString());
            fw.newLine();
            fw.write("PriorContinuousVar = ");
            fw.write(new Double(this.PriorContinuousVar).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#evolving mode section");
            fw.newLine();
            fw.write("Evol = ");
            fw.write(new Integer(this.Evol).toString());
            fw.newLine();
            fw.write("EvolVarIn = ");
            fw.write(new Integer(this.EvolVarIn).toString());
            fw.newLine();
            if (!this.EvolVarInFile.equals("")) {
                fw.write("EvolVarInFile = ");
                fw.write(this.EvolVarInFile);
                fw.newLine();
            } else {
                fw.write("#EvolVarInFile = ");
                fw.newLine();
            }
            fw.write("EvolIncludeVariableThreshold = ");
            fw.write(new Double(this.EvolIncludeVariableThreshold).toString());
            fw.newLine();
            fw.write("EvolIncludeFactorThreshold = ");
            fw.write(new Double(this.EvolIncludeFactorThreshold).toString());
            fw.newLine();
            fw.write("EvolMiniumVariablesInFactor = ");
            fw.write(new Integer(this.EvolMiniumVariablesInFactor).toString());
            fw.newLine();
            fw.write("EvolMaximumFactors = ");
            fw.write(new Integer(this.EvolMaximumFactors).toString());
            fw.newLine();
            fw.write("EvolMaximumVariables = ");
            fw.write(new Integer(this.EvolMaximumVariables).toString());
            fw.newLine();
            fw.write("EvolMaximumVariablesPerIteration = ");
            fw.write(new Integer(this.EvolMaximumVariablesPerIteration).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#mcmc section");
            fw.newLine();
            fw.write("Burnin = ");
            fw.write(new Integer(this.burnin).toString());
            fw.newLine();
            fw.write("Burnin_Select = ");
            fw.write(new Integer(this.burnin_select).toString());
            fw.newLine();
            fw.write("nMCSamples = ");
            fw.write(new Integer(this.nmcSamples).toString());
            fw.newLine();
            fw.write("nMCSamples_Select = ");
            fw.write(new Integer(this.nmcSamples_select).toString());
            fw.newLine();
            fw.newLine();
            fw.write("#mornitoring section");
            fw.newLine();
            fw.write("PrintIteration = ");
            fw.write(new Integer(this.noisy).toString());
            fw.newLine();
            fw.write("alpha = ");
            fw.write(new Double(this.alpha).toString());
            fw.newLine();
            fw.write("alphaX = ");
            fw.write(new Double(this.alphax).toString());
            fw.newLine();
            fw.write("PriorAlphaA = ");
            fw.write(new Double(this.PriorAlphaA).toString());
            fw.newLine();
            fw.write("PriorAlphaB = ");
            fw.write(new Double(this.PriorAlphaB).toString());
            fw.newLine();
            fw.write("InclusionMethod = ");
            fw.write(new Integer(this.InclusionMethod).toString());
            fw.newLine();
            fw.write("InverseWishart = ");
            fw.write(new Integer(this.Wishart).toString());
            fw.newLine();
            fw.write("InverseWishartT0 = ");
            fw.write(new Integer(this.WishartT0).toString());
            fw.newLine();
            fw.newLine();
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static String removeSpace(String v) {
        if (v.length() > 0) {
            String nv = "";
            for (int i = 0; i < v.length(); ++i) {
                if (v.charAt(i) == ' ' || v.charAt(i) == '\t') continue;
                nv = nv + v.charAt(i);
            }
            return nv;
        }
        return v;
    }
}

