/*
 * Decompiled with CFR 0.152.
 */
package dataframe;

import dataframe.ChipData;
import dataframe.TextArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Mapper
implements Serializable {
    private String[] mc1;
    private String[] mc2;
    private Hashtable mMap;
    private String[] mMapPair;
    private int mnRows;
    private int mnSkip;
    private int mnColumn1;
    private int mnColumn2;
    private String mstrSeparator;

    public Mapper() {
        this.init();
    }

    private void init() {
        this.mMap = new Hashtable();
        this.mnRows = 0;
        this.mnSkip = 0;
        this.mnColumn1 = 1;
        this.mnColumn2 = 2;
        this.mstrSeparator = " \t\n\r\f";
    }

    public Mapper(String file) {
        this.init();
        this.load(file, 0);
    }

    public Mapper(String file, int skip) {
        this.init();
        this.load(file, skip);
    }

    public Mapper(String file, int skip, String sep, int c1, int c2) {
        this.init();
        this.set(sep, skip, c1, c2);
        this.load(file, skip);
    }

    public Mapper(Object[] c1, Object[] c2) {
        this.init();
        if (c1 == null || c2 == null || c1.length != c2.length) {
            System.out.println("Invalid mappings");
            return;
        }
        this.mnRows = c1.length;
        this.mc1 = new String[this.mnRows];
        this.mc2 = new String[this.mnRows];
        for (int i = 0; i < this.mnRows; ++i) {
            this.mc1[i] = (String)c1[i];
            this.mc2[i] = (String)c2[i];
        }
        this.rebuild();
    }

    public Mapper(Object[] c1) {
        this.init();
        if (c1 == null) {
            System.out.println("Invalid mappings");
            return;
        }
        this.mnRows = c1.length;
        this.mc1 = new String[this.mnRows];
        this.mc2 = new String[this.mnRows];
        for (int i = 0; i < this.mnRows; ++i) {
            this.mc1[i] = (String)c1[i];
            this.mc2[i] = (String)c1[i];
        }
        this.rebuild();
    }

    public Mapper(String[] c1, String[] c2) {
        this.init();
        if (c1.length != c2.length) {
            System.out.println("c1 and c2 must have the same number of items");
            return;
        }
        this.mnRows = c1.length;
        this.mc1 = new String[this.mnRows];
        this.mc2 = new String[this.mnRows];
        for (int i = 0; i < this.mnRows; ++i) {
            this.mc1[i] = c1[i];
            this.mc2[i] = c2[i];
        }
        this.rebuild();
    }

    public Mapper(String[] c1) {
        this.init();
        if (c1 == null) {
            System.out.println("Invalid mappings");
            return;
        }
        this.mnRows = c1.length;
        this.mc1 = new String[this.mnRows];
        this.mc2 = new String[this.mnRows];
        for (int i = 0; i < this.mnRows; ++i) {
            this.mc1[i] = c1[i];
            this.mc2[i] = c1[i];
        }
        this.rebuild();
    }

    public void setSeparator(String sep) {
        this.set(sep, this.mnSkip, this.mnColumn1, this.mnColumn2);
    }

    public void set(String sep, int skip, int c1, int c2) {
        this.mstrSeparator = sep;
        this.mnSkip = skip;
        this.mnColumn1 = c1;
        this.mnColumn2 = c2;
        if (sep.equalsIgnoreCase("\\t") || sep.equalsIgnoreCase("tab")) {
            this.mstrSeparator = "\t";
        }
        if (sep.equalsIgnoreCase("space")) {
            this.mstrSeparator = " ";
        }
        if (sep.equalsIgnoreCase("comma")) {
            this.mstrSeparator = ",";
        }
        if (sep.equalsIgnoreCase("semicolon")) {
            this.mstrSeparator = ";";
        }
        if (sep.equalsIgnoreCase("default")) {
            this.mstrSeparator = " \t\n\r\f";
        }
    }

    public String[] c1() {
        return this.mc1;
    }

    public String c1m(int index) {
        if (index < 1 || index > this.mnRows) {
            System.out.println("Index out of bound");
            return null;
        }
        return this.mc1[index - 1];
    }

    public String c1j(int index) {
        return this.c1m(index + 1);
    }

    public String[] c2() {
        return this.mc2;
    }

    public String c2m(int index) {
        if (index < 1 || index > this.mnRows) {
            System.out.println("Index out of bound");
            return null;
        }
        return this.mc2[index - 1];
    }

    public String c2j(int index) {
        return this.c2m(index + 1);
    }

    public String[] map() {
        return this.mMapPair;
    }

    public String mapm(int index) {
        if (index < 1 || index > this.mnRows) {
            System.out.println("Index out of bound");
            return null;
        }
        return this.mMapPair[index - 1];
    }

    public String mapj(int index) {
        return this.mapm(index + 1);
    }

    public boolean save(String FileName) {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
            if (this.mnRows > 0) {
                for (int i = 0; i < this.mnRows; ++i) {
                    fw.write(this.mc1[i]);
                    if (this.mstrSeparator.length() == 1) {
                        fw.write(this.mstrSeparator);
                    } else {
                        fw.write("\t");
                    }
                    fw.write(this.mc2[i]);
                    if (i == this.mnRows - 1) continue;
                    fw.newLine();
                }
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Save file " + FileName + " failed");
            return false;
        }
        return true;
    }

    public String[] translate(Object[] list, String direction) {
        return this.translate((String[])list, direction);
    }

    public String[] translate(char[] list, String direction) {
        return this.translate(TextArray.toStrings(list), direction);
    }

    public String[] translate(char[][] list, String direction) {
        return this.translate(TextArray.toStrings(list), direction);
    }

    public String[] translate(String[] list, String direction) {
        Vector CleanList = this.parseObjectArray(list);
        if (CleanList.isEmpty()) {
            System.out.println("Input list is empty");
            return null;
        }
        Vector<String> ids = new Vector<String>();
        boolean bDir = direction.toLowerCase().startsWith("f");
        for (int i = 0; i < this.mc1.length; ++i) {
            if (bDir) {
                if (CleanList.contains(this.mc1[i])) {
                    ids.add(this.mc2[i]);
                    continue;
                }
                ids.add("NoMatch");
                continue;
            }
            if (CleanList.contains(this.mc2[i])) {
                ids.add(this.mc1[i]);
                continue;
            }
            ids.add("NoMatch");
        }
        if (ids.isEmpty()) {
            System.out.println("No matched items are found.");
            return null;
        }
        String[] id = new String[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            id[i] = (String)ids.get(i);
        }
        return id;
    }

    public String[] removeNoMatch(String[] list) {
        Vector<String> ids = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].equals("NoMatch")) continue;
            ids.add(list[i]);
        }
        if (ids.isEmpty()) {
            return null;
        }
        String[] id = new String[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            id[i] = (String)ids.get(i);
        }
        return id;
    }

    public Mapper subset(char[][] list, int who) {
        return this.subset(TextArray.toStrings(list), who);
    }

    public Mapper subset(char[] list, int who) {
        return this.subset(TextArray.toStrings(list), who);
    }

    public Mapper subset(Object[] list, int who) {
        return this.subset((String[])list, who);
    }

    public Mapper subset(String[] list, int who) {
        int i;
        Vector CleanList = this.parseObjectArray(list);
        Vector<Integer> index = new Vector<Integer>();
        if (who == 1) {
            for (i = 0; i < this.mnRows; ++i) {
                if (!CleanList.contains(this.mc1[i])) continue;
                index.add(new Integer(i));
            }
        } else {
            for (i = 0; i < this.mnRows; ++i) {
                if (!CleanList.contains(this.mc2[i])) continue;
                index.add(new Integer(i));
            }
        }
        if (index.isEmpty()) {
            System.out.println("The subset is empty");
            return null;
        }
        String[] c1 = new String[index.size()];
        String[] c2 = new String[index.size()];
        for (int i2 = 0; i2 < index.size(); ++i2) {
            c1[i2] = this.mc1[(Integer)index.get(i2)];
            c2[i2] = this.mc2[(Integer)index.get(i2)];
        }
        return new Mapper(c1, c2);
    }

    public Object[] align(TextArray X, TextArray Y) {
        int i;
        this.noMatch();
        if (this.mc1 == null || this.mc2 == null || this.mc1.length == 0 || this.mc2.length == 0 || this.mc1.length != this.mc2.length) {
            System.out.println("Error: Invalid map. Please try to load an valid map first");
            return null;
        }
        if (X == null || !X.hasUniqueKey()) {
            System.out.println("Error: empty X object or keys not found for X object");
            return null;
        }
        if (Y == null || !Y.hasUniqueKey()) {
            System.out.println("Error: empty Y object or keys not found for Y object");
            return null;
        }
        Hashtable<String, Integer> PX = new Hashtable<String, Integer>();
        for (int i2 = 0; i2 < X.keys().length; ++i2) {
            PX.put(X.keys()[i2], new Integer(i2));
        }
        Hashtable<String, Integer> PY = new Hashtable<String, Integer>();
        for (int i3 = 0; i3 < Y.keys().length; ++i3) {
            PY.put(Y.keys()[i3], new Integer(i3));
        }
        Vector IndexX = new Vector();
        Vector IndexY = new Vector();
        for (int i4 = 0; i4 < this.mc1.length; ++i4) {
            if (!PX.containsKey(this.mc1[i4]) || !PY.containsKey(this.mc2[i4])) continue;
            IndexX.add(PX.get(this.mc1[i4]));
            IndexY.add(PY.get(this.mc2[i4]));
        }
        if (IndexX.size() == 0) {
            System.out.println("No Match");
            this.noMatch();
            return null;
        }
        int row = IndexX.size();
        int c1 = X.columns().length;
        int c2 = Y.columns().length;
        Object[] columnsX = new Object[c1];
        Object[] columnsY = new Object[c2];
        for (i = 0; i < c1; ++i) {
            columnsX[i] = new String[row];
        }
        for (i = 0; i < c2; ++i) {
            columnsY[i] = new String[row];
        }
        String[] keyX = new String[row];
        String[] keyY = new String[row];
        for (int i5 = 0; i5 < row; ++i5) {
            int ix = (Integer)IndexX.get(i5);
            keyX[i5] = X.keyj(ix);
            for (int j = 0; j < c1; ++j) {
                ((String[])columnsX[j])[i5] = X.columnj(j)[ix];
            }
            int iy = (Integer)IndexY.get(i5);
            keyY[i5] = Y.keyj(iy);
            for (int j = 0; j < c2; ++j) {
                ((String[])columnsY[j])[i5] = Y.columnj(j)[iy];
            }
        }
        Object[] result = new Object[2];
        result[0] = new TextArray(columnsX);
        ((TextArray)result[0]).set(X.getSeparator(), X.getMissingValue(), X.getHeader());
        ((TextArray)result[0]).setColumnNames(X.columnnames());
        ((TextArray)result[0]).setKeys(keyX);
        result[1] = new TextArray(columnsY);
        ((TextArray)result[1]).set(Y.getSeparator(), Y.getMissingValue(), Y.getHeader());
        ((TextArray)result[1]).setColumnNames(Y.columnnames());
        ((TextArray)result[1]).setKeys(keyY);
        return result;
    }

    public Object[] align(ChipData X, ChipData Y) {
        this.noMatch();
        if (this.mc1 == null || this.mc2 == null || this.mc1.length == 0 || this.mc2.length == 0 || this.mc1.length != this.mc2.length) {
            System.out.println("Error: Invalid map. Please try to load an valid map first");
            return null;
        }
        if (X.probeid() == null || X.probeid().length == 0) {
            System.out.println("Error: Invalid X object. probeids not found.");
            return null;
        }
        if (Y.probeid() == null || Y.probeid().length == 0) {
            System.out.println("Error: Invalid Y object. probeid not found.");
            return null;
        }
        Hashtable<String, Integer> PX = new Hashtable<String, Integer>();
        for (int i = 0; i < X.probeid().length; ++i) {
            PX.put(X.probeid()[i], new Integer(i));
        }
        Hashtable<String, Integer> PY = new Hashtable<String, Integer>();
        for (int i = 0; i < Y.probeid().length; ++i) {
            PY.put(Y.probeid()[i], new Integer(i));
        }
        Vector IndexX = new Vector();
        Vector IndexY = new Vector();
        for (int i = 0; i < this.mc1.length; ++i) {
            if (!PX.containsKey(this.mc1[i]) || !PY.containsKey(this.mc2[i])) continue;
            IndexX.add(PX.get(this.mc1[i]));
            IndexY.add(PY.get(this.mc2[i]));
        }
        if (IndexX.size() == 0) {
            System.out.println("No Match");
            this.noMatch();
            return null;
        }
        int row = IndexX.size();
        int c1 = X.data()[0].length;
        int c2 = Y.data()[0].length;
        double[][] dataX = new double[row][c1];
        double[][] dataY = new double[row][c2];
        String[] idX = new String[row];
        String[] idY = new String[row];
        for (int i = 0; i < row; ++i) {
            int ix = (Integer)IndexX.get(i);
            idX[i] = X.probeid()[ix];
            for (int j = 0; j < c1; ++j) {
                dataX[i][j] = X.data()[ix][j];
            }
            int iy = (Integer)IndexY.get(i);
            idY[i] = Y.probeid()[iy];
            for (int j = 0; j < c2; ++j) {
                dataY[i][j] = Y.data()[iy][j];
            }
        }
        Object[] result = new Object[]{new ChipData(dataX, idX, X.columnnames()), new ChipData(dataY, idY, Y.columnnames())};
        return result;
    }

    private void noMatch() {
    }

    public boolean load(String FileName) {
        return this.load(FileName, this.mnSkip);
    }

    public boolean load(String FileName, int skip) {
        String str;
        this.mnRows = 0;
        int nColumns = 0;
        this.mnSkip = skip;
        int nLineCount = 0;
        BufferedReader br = TextArray.getBufferedReader(FileName);
        if (br == null) {
            return false;
        }
        try {
            while ((str = br.readLine()) != null) {
                if (++nLineCount <= this.mnSkip || nColumns != 0) continue;
                StringTokenizer st = new StringTokenizer(str, this.mstrSeparator);
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    ++nColumns;
                }
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        this.mnRows = nLineCount - this.mnSkip;
        this.mc1 = new String[this.mnRows];
        this.mc2 = new String[this.mnRows];
        nLineCount = 0;
        try {
            br = TextArray.getBufferedReader(FileName);
            if (br == null) {
                return false;
            }
            while ((str = br.readLine()) != null) {
                int nrow;
                if ((nrow = ++nLineCount - this.mnSkip - 1) < 0 || nrow >= this.mnRows) continue;
                int ncolumn = 0;
                int nFound = 0;
                StringTokenizer st = new StringTokenizer(str, this.mstrSeparator, true);
                boolean bToken = false;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!bToken) {
                        boolean bl = bToken = this.mstrSeparator.indexOf(token) >= 0;
                        if (bToken) {
                            token = "";
                        }
                        if (ncolumn + 1 == this.mnColumn1) {
                            this.mc1[nrow] = token.trim();
                            if (this.mc1[nrow].length() == 0 && nrow > 0) {
                                this.mc1[nrow] = this.mc1[nrow - 1];
                            }
                            ++nFound;
                        } else if (ncolumn + 1 == this.mnColumn2) {
                            this.mc2[nrow] = token.trim();
                            if (this.mc2[nrow].length() == 0 && nrow > 0) {
                                this.mc2[nrow] = this.mc2[nrow - 1];
                            }
                            ++nFound;
                        }
                        ++ncolumn;
                        if (nFound == 2) break;
                    }
                    bToken = !bToken;
                }
                if (nFound >= 2) continue;
                System.out.println("Cannot find a mapping for line " + nLineCount + ":");
                System.out.println(str);
                br.close();
                return false;
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        this.rebuild();
        return true;
    }

    private void rebuild() {
        this.mMap.clear();
        this.mMapPair = new String[this.mnRows];
        for (int i = 0; i < this.mnRows; ++i) {
            String strKey = this.mc1[i] + " " + this.mc2[i];
            this.mMap.put(strKey, new Integer(i));
            this.mMapPair[i] = strKey;
        }
    }

    private Vector parseObjectArray(String[] oa) {
        Vector<String> v = new Vector<String>();
        if (oa.length > 0) {
            for (int i = 0; i < oa.length; ++i) {
                String str = oa[i];
                if (str == null || str.length() <= 0) continue;
                v.add(str.trim());
            }
        }
        return v;
    }
}

