/*
 * Decompiled with CFR 0.152.
 */
package dataframe;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class TextArray
implements Serializable {
    private String mstrSeparator;
    private boolean mbHeader;
    private int mnRows;
    private int mnColumns;
    private int mnIgnore;
    private String mstrMissingValue;
    private String mstrDateFormat;
    private Vector mstrHeaderLines;
    public double[][] mdData;
    private int[] mnType;
    private Object[] mColumns;
    public String[] mstrKey;
    public String[] mColumnNames;
    private String mstrFileName;

    public TextArray() {
        this.init();
    }

    public TextArray(TextArray other) {
        this.createArray(other.columns(), null);
        this.set(other.getSeparator(), other.getMissingValue(), other.getHeader());
        this.setColumnNames(other.columnnames());
        this.setKeys(other.keys());
    }

    public TextArray(String FileName) {
        this.init();
        this.load(FileName);
    }

    public TextArray(Object[] strlist, String separator) {
        this.createArray((String[])strlist, separator);
    }

    public TextArray(String[] strlist, String separator) {
        this.createArray(strlist, separator);
    }

    public TextArray(char[][] strlist, String separator) {
        this.createArray(TextArray.toStrings(strlist), separator);
    }

    public TextArray(char[] strlist, String separator) {
        this.createArray(TextArray.toStrings(strlist), separator);
    }

    public TextArray(String FileName, boolean Header) {
        this.init();
        this.mbHeader = Header;
        this.load(FileName);
    }

    public TextArray(String FileName, String Sep, String MissingValue, boolean Header) {
        this.init();
        this.set(Sep, MissingValue, Header);
        this.load(FileName);
    }

    public TextArray(String FileName, String Sep, String MissingValue, boolean Header, int Ignore) {
        this.init();
        this.set(Sep, MissingValue, Header);
        this.mnIgnore = Ignore;
        this.load(FileName);
    }

    public TextArray(String FileName, String Sep, String MissingValue, boolean Header, String DateFormat) {
        this.init();
        this.set(Sep, MissingValue, Header);
        this.mstrDateFormat = DateFormat;
        this.load(FileName);
    }

    private void init() {
        this.mstrSeparator = " \t\n\r\f";
        this.mbHeader = false;
        this.mstrMissingValue = "NA";
        this.mnColumns = 0;
        this.mnRows = 0;
        this.mstrDateFormat = "yyyy/MM/dd";
        this.mnIgnore = 0;
        this.mstrHeaderLines = new Vector();
    }

    public void setHeaderLines(Object[] lines) {
        this.setHeaderLines((String[])lines);
    }

    public void setHeaderLines(char[][] lines) {
        this.setHeaderLines(TextArray.toStrings(lines));
    }

    public void setHeaderLines(char[] lines) {
        this.setHeaderLines(TextArray.toStrings(lines));
    }

    public void setHeaderLines(String[] lines) {
        this.mstrHeaderLines.clear();
        if (lines == null || lines.length == 0) {
            return;
        }
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null || lines[i].length() == 0) {
                this.mstrHeaderLines.add("");
                continue;
            }
            this.mstrHeaderLines.add(lines[i]);
        }
    }

    public void setDateFromat(String f) {
        this.mstrDateFormat = f;
    }

    public TextArray(Object[] columns) {
        this.createArray(columns, null);
    }

    public TextArray(Object[] columns, String[] headers) {
        this.createArray(columns, headers);
    }

    public TextArray(Object[] columns, char[][] headers) {
        this.createArray(columns, TextArray.toStrings(headers));
    }

    public TextArray(Object[] columns, char[] headers) {
        this.createArray(columns, TextArray.toStrings(headers));
    }

    public TextArray(double[][] data) {
        this.createArray(data, null, null, null);
    }

    public TextArray(double[][] data, String[] headers, String[] rows) {
        this.createArray(data, headers, rows, null);
    }

    public TextArray(double[][] data, String[] headers, char[][] rows) {
        this.createArray(data, headers, TextArray.toStrings(rows), null);
    }

    public TextArray(double[][] data, char[][] headers, char[][] rows) {
        this.createArray(data, TextArray.toStrings(headers), TextArray.toStrings(rows), null);
    }

    public TextArray(double[][] data, char[][] headers, String[] rows) {
        this.createArray(data, TextArray.toStrings(headers), rows, null);
    }

    public TextArray getDataArray() {
        if (this.data() == null || this.data()[0].length == 0) {
            return null;
        }
        return new TextArray(this.data(), this.datacolumnnames(), this.keys());
    }

    public TextArray(double[][] data, String[] headers, String[] rows, String format) {
        this.createArray(data, headers, rows, format);
    }

    private void createArray(double[][] data, String[] headers, String[] rows, String format) {
        this.init();
        if (data == null) {
            System.out.println("No data are available");
            return;
        }
        int nrow = data.length;
        int ncolumn = data[0].length;
        if (rows != null && rows.length != data.length) {
            System.out.println("The number of rows in data must match the number of rows in row names");
            return;
        }
        Object[] columns = new Object[ncolumn];
        for (int i = 0; i < ncolumn; ++i) {
            columns[i] = new String[nrow];
        }
        int nCurrentColumn = 0;
        String strFormat = "#.######";
        if (format != null && format.length() > 0) {
            strFormat = format;
        }
        DecimalFormat df = new DecimalFormat(strFormat);
        for (int j = nCurrentColumn; j < ncolumn; ++j) {
            String[] col = (String[])columns[j];
            for (int i = 0; i < nrow; ++i) {
                col[i] = Double.isNaN(data[i][j - nCurrentColumn]) ? this.mstrMissingValue : df.format(data[i][j - nCurrentColumn]).toString();
            }
        }
        if (rows != null && headers != null) {
            String[] newHeaders = new String[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                newHeaders[i] = headers[i];
            }
            this.createArray(columns, newHeaders);
        } else {
            this.createArray(columns, headers);
        }
        if (rows != null) {
            this.setKeys(rows);
        }
    }

    public TextArray merge(TextArray other) {
        Object[] result = this.merge0(other);
        if (result == null) {
            return null;
        }
        return (TextArray)result[0];
    }

    public void summarize() {
        System.out.println("Number of columns read: " + this.mnColumns);
        System.out.println("Number of rows read: " + this.mnRows);
        if (this.datacolumnnames() != null) {
            System.out.println("Number of data columns read: " + this.datacolumnnames().length);
        }
        if (this.mnRows > 0 && !this.hasUniqueKey()) {
            System.out.println("This object does not have unique row IDs(keys)");
        }
        if (this.datacolumnnames() != null && this.datacolumnnames().length > 0) {
            int nMissingCount = 0;
            for (int j = 0; j < this.mnColumns; ++j) {
                for (int i = 0; i < this.mnRows; ++i) {
                    if (!((String[])this.mColumns[j])[i].equalsIgnoreCase(this.mstrMissingValue)) continue;
                    ++nMissingCount;
                }
            }
            if (nMissingCount > 0) {
                System.out.println("Number of missing values: " + nMissingCount);
            }
        }
    }

    public int getColumnIndexm(String columnName) {
        for (int i = 0; i < this.mnColumns; ++i) {
            if (!this.mColumnNames[i].toLowerCase().equals(columnName.toLowerCase())) continue;
            return i + 1;
        }
        System.out.println("Column " + columnName + " not found");
        return 0;
    }

    public TextArray union(TextArray other, String columnName) {
        if (other == null) {
            System.out.println("Input must be a valid TextArray Object");
            return null;
        }
        int Index1 = this.getColumnIndexm(columnName) - 1;
        if (Index1 < 0) {
            return null;
        }
        int Index2 = other.getColumnIndexm(columnName);
        if (Index2 < 0) {
            return null;
        }
        Hashtable XOrder = this.parseDuplicatedStringArray(this.columnj(Index1));
        Hashtable YOrder = this.parseDuplicatedStringArray(other.columnj(Index2));
        Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>(1000);
        Enumeration e = XOrder.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            if (!YOrder.containsKey(strKey)) continue;
            Vector IndexesX = (Vector)XOrder.get(strKey);
            Vector IndexesY = (Vector)YOrder.get(strKey);
            for (int i = 0; i < IndexesX.size(); ++i) {
                Integer X = (Integer)IndexesX.elementAt(i);
                for (int j = 0; j < IndexesY.size(); ++j) {
                    Integer Y = (Integer)IndexesY.elementAt(j);
                    map.put(X, Y);
                }
            }
        }
        return null;
    }

    public Object[] merge0(TextArray other) {
        String strKey;
        if (other == null) {
            System.out.println("Input must be a valid TextArray Object");
            return null;
        }
        if (!this.hasUniqueKey() || !other.hasUniqueKey()) {
            System.out.println("Must have unique keys");
            return null;
        }
        Hashtable XOrder = this.parseStringArray(this.mstrKey);
        Hashtable YOrder = this.parseStringArray(other.keys());
        if (XOrder.size() == 0 || YOrder.size() == 0) {
            System.out.println("Error: Keys not found");
            return null;
        }
        int r1 = this.mnRows;
        int c1 = this.mnColumns;
        int r2 = other.keys().length;
        int c2 = other.columnnames().length;
        if (r1 == 0 || r2 == 0 || c1 == 0 || c2 == 0) {
            System.out.println("Error: Data not in good format");
            return null;
        }
        Vector<String> XE = new Vector<String>(100);
        Vector<String> YE = new Vector<String>(100);
        Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>(1000);
        Enumeration e = XOrder.keys();
        while (e.hasMoreElements()) {
            strKey = (String)e.nextElement();
            if (YOrder.containsKey(strKey)) {
                Integer IndexX = (Integer)XOrder.get(strKey);
                Integer IndexY = (Integer)YOrder.get(strKey);
                map.put((Integer)XOrder.get(strKey), (Integer)YOrder.get(strKey));
                continue;
            }
            XE.add(strKey);
        }
        e = YOrder.keys();
        while (e.hasMoreElements()) {
            strKey = (String)e.nextElement();
            if (XOrder.containsKey(strKey)) continue;
            YE.add(strKey);
        }
        String[] XExtra = null;
        String[] YExtra = null;
        if (XE.size() > 0) {
            XExtra = new String[XE.size()];
            for (int i = 0; i < XE.size(); ++i) {
                XExtra[i] = ((String)XE.get(i)).trim();
            }
        }
        if (YE.size() > 0) {
            YExtra = new String[YE.size()];
            for (int i = 0; i < YE.size(); ++i) {
                YExtra[i] = ((String)YE.get(i)).trim();
            }
        }
        int nRow = map.size();
        String[] strOrder = new String[nRow];
        int i = nRow - 1;
        Enumeration e2 = map.keys();
        while (e2.hasMoreElements()) {
            int ix = (Integer)e2.nextElement();
            strOrder[i] = this.mstrKey[ix];
            --i;
        }
        Object[] result = new Object[5];
        TextArray taX = this.selectRows(strOrder);
        TextArray taY = other.selectRows(strOrder);
        result[0] = this.concatenate(taX, taY);
        result[1] = taX;
        result[2] = taY;
        result[3] = XExtra;
        result[4] = YExtra;
        return result;
    }

    public TextArray concatenate(TextArray taX, TextArray taY) {
        int i;
        if (taX == null || taY == null) {
            System.out.println("Error: Empty TextArray found");
            return null;
        }
        if (taX.keys().length != taY.keys().length) {
            System.out.println("TextArrays must have the same number of rows");
            return null;
        }
        int nColumn = taX.columnnames().length + taY.columnnames().length;
        Object[] cat = new Object[nColumn];
        String[] catNames = new String[nColumn];
        for (i = 0; i < taX.columnnames().length; ++i) {
            cat[i] = taX.columnj(i);
            catNames[i] = taX.columnnamej(i);
        }
        for (i = 0; i < taY.columnnames().length; ++i) {
            cat[i + taX.columnnames().length] = taY.columnj(i);
            catNames[i + taX.columnnames().length] = taY.columnnamej(i);
        }
        TextArray taCat = new TextArray(cat);
        taCat.set(this.getSeparator(), this.getMissingValue(), this.getHeader());
        taCat.setColumnNames(catNames);
        taCat.setKeys(taX.keys());
        return taCat;
    }

    public TextArray selectRows(char[] keys) {
        return this.selectRows(TextArray.toStrings(keys));
    }

    public TextArray selectRows(char[][] keys) {
        return this.selectRows(TextArray.toStrings(keys));
    }

    public TextArray selectRows(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        String[] strkeys = new String[keys.length];
        for (int i = 0; i < strkeys.length; ++i) {
            strkeys[i] = keys[i] != null ? (String)keys[i] : "";
        }
        return this.selectRows(strkeys);
    }

    public TextArray selectRows(String[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        Hashtable htKeys = this.parseStringArray(this.mstrKey);
        Vector<Integer> index = new Vector<Integer>();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null || !htKeys.containsKey(keys[i].trim())) continue;
            index.add((Integer)htKeys.get(keys[i].trim()));
        }
        if (index.size() == 0) {
            return null;
        }
        int[] nIndex = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            nIndex[i] = (Integer)index.get(i) + 1;
        }
        return this.selectRowsm(nIndex);
    }

    public TextArray selectColumns(char[] cnames) {
        return this.selectColumns(TextArray.toStrings(cnames));
    }

    public TextArray selectColumns(char[][] cnames) {
        return this.selectColumns(TextArray.toStrings(cnames));
    }

    public TextArray selectColumns(Object[] cnames) {
        if (cnames == null || cnames.length == 0) {
            return null;
        }
        String[] strnames = new String[cnames.length];
        for (int i = 0; i < strnames.length; ++i) {
            strnames[i] = cnames[i] != null ? (String)cnames[i] : "";
        }
        return this.selectColumns(strnames);
    }

    public TextArray selectColumns(String[] cnames) {
        if (cnames == null || cnames.length == 0) {
            return null;
        }
        Hashtable htnames = this.parseStringArray(cnames);
        Vector<Integer> index = new Vector<Integer>();
        for (int i = 0; i < this.mnColumns; ++i) {
            if (!htnames.containsKey(this.mColumnNames[i])) continue;
            index.add(new Integer(i));
        }
        if (index.size() == 0) {
            return null;
        }
        int[] nIndex = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            nIndex[i] = (Integer)index.get(i) + 1;
        }
        return this.selectColumnsm(nIndex);
    }

    public TextArray selectColumnsj(int[] columnIndexes) {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return null;
        }
        int[] newColumns = new int[columnIndexes.length];
        for (int i = 0; i < columnIndexes.length; ++i) {
            newColumns[i] = columnIndexes[i] + 1;
        }
        return this.selectColumnsm(newColumns);
    }

    public TextArray selectColumnsm(int[] columnIndexes) {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return null;
        }
        for (int i = 0; i < columnIndexes.length; ++i) {
            if (columnIndexes[i] >= 1 && columnIndexes[i] <= this.mnColumns) continue;
            System.out.println("Row index out of bound");
            return null;
        }
        Object[] columns = new Object[columnIndexes.length];
        String[] cnames = new String[columnIndexes.length];
        for (int j = 0; j < columnIndexes.length; ++j) {
            columns[j] = this.mColumns[columnIndexes[j] - 1];
            cnames[j] = this.mColumnNames[columnIndexes[j] - 1];
        }
        TextArray result = new TextArray(columns);
        result.set(this.getSeparator(), this.getMissingValue(), this.getHeader());
        result.setColumnNames(cnames);
        result.setKeys(this.keys());
        return result;
    }

    public TextArray selectRowsm(int[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] >= 1 && keys[i] <= this.mnRows) continue;
            System.out.println("Row index out of bound");
            return null;
        }
        Object[] columns = new Object[this.mnColumns];
        String[] rownames = new String[keys.length];
        for (int j = 0; j < this.mnColumns; ++j) {
            columns[j] = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                ((String[])columns[j])[i] = this.columnj(j)[keys[i] - 1];
            }
        }
        for (int i = 0; i < keys.length; ++i) {
            rownames[i] = this.mstrKey[keys[i] - 1];
        }
        TextArray result = new TextArray(columns);
        result.set(this.getSeparator(), this.getMissingValue(), this.getHeader());
        result.setColumnNames(this.columnnames());
        result.setKeys(rownames);
        return result;
    }

    public TextArray selectRowsj(int[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        int[] newKeys = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            newKeys[i] = keys[i] + 1;
        }
        return this.selectRowsm(newKeys);
    }

    public void transpose() {
        if (this.mColumns == null || this.mColumnNames == null || this.mstrKey == null || this.mnRows == 0 || this.mnColumns == 0) {
            return;
        }
        String[] strOldColumnNames = new String[this.mColumnNames.length];
        for (int i = 0; i < this.mColumnNames.length; ++i) {
            strOldColumnNames[i] = this.mColumnNames[i];
        }
        String[] strOldKey = new String[this.mstrKey.length];
        for (int i = 0; i < this.mstrKey.length; ++i) {
            strOldKey[i] = this.mstrKey[i];
        }
        int nRows = this.mnRows;
        this.mnRows = this.mnColumns;
        this.mnColumns = nRows;
        Object[] newColumns = new Object[this.mnColumns];
        for (int j = 0; j < this.mnColumns; ++j) {
            newColumns[j] = new String[this.mnRows];
            for (int i = 0; i < this.mnRows; ++i) {
                ((String[])newColumns[j])[i] = ((String[])this.mColumns[i])[j];
            }
        }
        this.parseData(newColumns, strOldKey);
        this.analyze();
        this.mstrKey = strOldColumnNames;
        this.mColumnNames = strOldKey;
    }

    private void createArray(String[] strlist, String separator) {
        int i;
        this.init();
        this.set(separator, this.mstrMissingValue, false);
        if (strlist == null || strlist.length == 0) {
            System.out.println("No strings are found");
            return;
        }
        int nFieldCount = this.getFieldCount(strlist[0]);
        if (nFieldCount == 0) {
            System.out.println("No strings are found");
            return;
        }
        Object[] columns = new Object[strlist.length];
        for (i = 0; i < strlist.length; ++i) {
            columns[i] = this.parseString(strlist[i], nFieldCount);
        }
        this.createArray(columns, null);
        System.out.println();
        this.transpose();
        for (i = 0; i < this.mnColumns; ++i) {
            this.mColumnNames[i] = new Integer(i + 1).toString();
        }
    }

    private void createArray(Object[] columns, String[] headers) {
        this.init();
        if (columns == null) {
            System.out.println("No columns are defined");
            return;
        }
        boolean bl = this.mbHeader = headers != null;
        if (this.mbHeader && columns.length != headers.length) {
            System.out.println("The Number of column names must match the number of columns");
            return;
        }
        this.mnColumns = columns.length;
        this.mnRows = ((String[])columns[0]).length;
        this.parseData(columns, headers);
        this.analyze();
    }

    public Object[] columns() {
        return this.mColumns;
    }

    public void setColumnNames(char[] cnames) {
        this.setColumnNames(TextArray.toStrings(cnames));
    }

    public void setColumnNames(char[][] cnames) {
        this.setColumnNames(TextArray.toStrings(cnames));
    }

    public void setColumnNames(Object[] cnames) {
        this.setColumnNames((String[])cnames);
    }

    public void setColumnNames(String[] cnames) {
        if (cnames == null || cnames.length == 0) {
            System.out.println("Error: empty input parameters. Function call ignored");
            return;
        }
        if (cnames.length != this.mnColumns) {
            System.out.println("Error: the number of new column names does not match. Function call ignored");
            return;
        }
        for (int i = 0; i < this.mnColumns; ++i) {
            if (cnames[i] == null && cnames[i].trim().length() == 0) continue;
            this.mColumnNames[i] = cnames[i];
        }
    }

    public void setKeys(Object[] keys) {
        this.setKeys((String[])keys);
    }

    public void setKeys(char[] keys) {
        this.setKeys(TextArray.toStrings(keys));
    }

    public void setKeys(char[][] keys) {
        this.setKeys(TextArray.toStrings(keys));
    }

    public void setKeys(String[] keys) {
        if (keys == null || keys.length == 0) {
            System.out.println("Error: empty input parameters. Function call ignored");
            return;
        }
        if (keys.length != this.mnRows) {
            System.out.println("Error: the number of new keys does not match. Function call ignored");
            return;
        }
        for (int i = 0; i < this.mnRows; ++i) {
            if (keys[i] == null && keys[i].trim().length() == 0) continue;
            this.mstrKey[i] = keys[i];
        }
    }

    public void replaceKeys(String[] keys) {
        if (keys == null || keys.length == 0) {
            System.out.println("Error: empty input parameters. Function call ignored");
            return;
        }
        if (keys.length != this.mnRows) {
            System.out.println("Error: the number of new keys does not match. Function call ignored");
            return;
        }
        for (int i = 0; i < this.mnRows; ++i) {
            if (keys[i] == null && keys[i].trim().length() == 0) continue;
            ((String[])this.mColumns[0])[i] = keys[i];
        }
        this.analyze();
    }

    public static String[] toStrings(char[][] list) {
        int i;
        if (list == null || list.length == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (i = 0; i < list.length; ++i) {
            if (list[i] == null || list[i].length == 0) continue;
            String strCurrent = new String(list[i]).trim();
            v.add(strCurrent);
        }
        if (v.isEmpty()) {
            return null;
        }
        String[] res = new String[v.size()];
        while (i < res.length) {
            res[i] = (String)v.get(i);
            ++i;
        }
        return res;
    }

    public static String[] toStrings(char[] list) {
        if (list == null || list.length == 0) {
            return null;
        }
        String[] res = new String[]{new String(list)};
        res[0] = res[0].trim();
        return res;
    }

    public boolean save(String FileName) {
        return this.save(FileName, "\t");
    }

    public boolean save(String FileName, String sep) {
        return this.save(FileName, this.mbHeader, false, true, sep);
    }

    public boolean saveAll(String FileName) {
        return this.save(FileName, true, true, true, "\t");
    }

    public boolean save(String FileName, boolean header, boolean key, boolean data) {
        return this.save(FileName, header, key, data, "\t");
    }

    public boolean save(String FileName, boolean header, boolean key, boolean data, String sep) {
        try {
            int i;
            BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
            if (!this.mstrHeaderLines.isEmpty()) {
                for (i = 0; i < this.mstrHeaderLines.size(); ++i) {
                    if (((String)this.mstrHeaderLines.get(i)).length() != 0) {
                        fw.write((String)this.mstrHeaderLines.get(i));
                    }
                    fw.newLine();
                }
            }
            if (this.mnColumns > 0) {
                if (header) {
                    if (key) {
                        fw.write("key");
                        fw.write(sep);
                    }
                    if (data || !data && !key) {
                        fw.write(this.mColumnNames[0]);
                        for (i = 1; i < this.mnColumns; ++i) {
                            fw.write(sep);
                            fw.write(this.mColumnNames[i]);
                        }
                    }
                    fw.newLine();
                }
                if (this.mnRows > 0) {
                    for (i = 0; i < this.mnRows; ++i) {
                        if (key) {
                            fw.write(this.mstrKey[i]);
                            fw.write(sep);
                        }
                        if (data) {
                            fw.write(((String[])this.mColumns[0])[i]);
                            for (int j = 1; j < this.mnColumns; ++j) {
                                fw.write(sep);
                                fw.write(((String[])this.mColumns[j])[i]);
                            }
                        }
                        if (i == this.mnRows - 1) continue;
                        fw.newLine();
                    }
                }
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Save file " + FileName + " failed");
            return false;
        }
        return true;
    }

    public void set(String Separator, String MissingValue, boolean Header) {
        this.mbHeader = Header;
        this.mstrMissingValue = MissingValue;
        this.mstrSeparator = Separator;
        if (Separator.equalsIgnoreCase("\\t") || Separator.equalsIgnoreCase("tab")) {
            this.mstrSeparator = "\t";
        }
        if (Separator.equalsIgnoreCase("space")) {
            this.mstrSeparator = " ";
        }
        if (Separator.equalsIgnoreCase("comma")) {
            this.mstrSeparator = ",";
        }
        if (Separator.equalsIgnoreCase("semicolon")) {
            this.mstrSeparator = ";";
        }
        if (Separator.equalsIgnoreCase("default")) {
            this.mstrSeparator = " \t\n\r\f";
        }
    }

    public int[] types() {
        return this.mnType;
    }

    public int typem(int index) {
        if (index < 1 || index > this.mnColumns) {
            System.out.println("Index out of bound");
            return -1;
        }
        return this.mnType[index - 1];
    }

    public int typej(int index) {
        return this.typem(index + 1);
    }

    public String[] columnm(String name) {
        for (int i = 0; i < this.mnColumns; ++i) {
            if (!this.mColumnNames[i].equals(name)) continue;
            return this.columnm(i + 1);
        }
        return null;
    }

    public String[] columnm(int index) {
        if (index < 1 || index > this.mnColumns) {
            System.out.println("Index out of bound");
            return null;
        }
        return (String[])this.mColumns[index - 1];
    }

    public String[] columnj(int index) {
        return this.columnm(index + 1);
    }

    public double[][] data() {
        return this.mdData;
    }

    public String[] keys() {
        return this.mstrKey;
    }

    public String keym(int index) {
        if (index < 1 || index > this.mnRows) {
            System.out.println("Index out of bound");
            return null;
        }
        return this.mstrKey[index - 1];
    }

    public boolean applyCodeTable(TextArray codeTable) {
        Hashtable CurrentColumn;
        if (codeTable == null) {
            System.out.println("Invalid Code Table");
            return false;
        }
        if (codeTable.columnnames().length < 3) {
            System.out.println("A code table must have at least 3 columns");
            return false;
        }
        String[] ColumnNames = codeTable.columnj(0);
        String[] OldValues = codeTable.columnj(1);
        String[] NewValues = codeTable.columnj(2);
        String[] OldKeys = new String[this.mstrKey.length];
        for (int k = 0; k < OldKeys.length; ++k) {
            OldKeys[k] = this.mstrKey[k];
        }
        Hashtable htColumns = new Hashtable();
        for (int i = 0; i < ColumnNames.length; ++i) {
            if (!htColumns.containsKey(ColumnNames[i])) {
                Hashtable htCol = new Hashtable();
                htColumns.put(ColumnNames[i], htCol);
            }
            CurrentColumn = (Hashtable)htColumns.get(ColumnNames[i]);
            CurrentColumn.put(OldValues[i], NewValues[i]);
        }
        for (int j = 0; j < this.mnColumns; ++j) {
            if (!htColumns.containsKey(this.mColumnNames[j])) continue;
            CurrentColumn = (Hashtable)htColumns.get(this.mColumnNames[j]);
            for (int i = 0; i < this.mnRows; ++i) {
                if (!CurrentColumn.containsKey(((String[])this.mColumns[j])[i])) continue;
                ((String[])this.mColumns[j])[i] = (String)CurrentColumn.get(((String[])this.mColumns[j])[i]);
            }
        }
        this.analyze();
        for (int k = 0; k < OldKeys.length; ++k) {
            this.mstrKey[k] = OldKeys[k];
        }
        return true;
    }

    public TextArray createCodeTablem(char[] names, boolean generateDefault) {
        return this.createCodeTablem(TextArray.toStrings(names), generateDefault);
    }

    public TextArray createCodeTablem(char[][] names, boolean generateDefault) {
        return this.createCodeTablem(TextArray.toStrings(names), generateDefault);
    }

    public TextArray createCodeTablem(Object[] names, boolean generateDefault) {
        if (names == null || names.length == 0) {
            System.out.println("No valid column names are found");
            return null;
        }
        String[] strNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            strNames[i] = names[i] != null ? (String)names[i] : "";
        }
        return this.createCodeTablem(strNames, generateDefault);
    }

    public TextArray createCodeTablem(String[] names, boolean generateDefault) {
        if (names == null || names.length == 0) {
            System.out.println("No valid column names are found");
            return null;
        }
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null || names[i].trim().length() == 0) continue;
            ht.put(names[i].trim(), new Integer(i + 1));
        }
        Vector<Integer> index = new Vector<Integer>();
        for (int i = 0; i < this.mnColumns; ++i) {
            if (!ht.containsKey(this.mColumnNames[i])) continue;
            index.add(new Integer(i + 1));
        }
        if (index.size() == 0) {
            System.out.println("No valid column names are found");
            return null;
        }
        if (index.size() < names.length) {
            System.out.println("Warning: Not all column names are valid");
        }
        int[] nID = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            nID[i] = (Integer)index.get(i);
        }
        return this.createCodeTablem(nID, generateDefault);
    }

    public TextArray createCodeTablem(int[] index, boolean generateDefault) {
        if (index == null || index.length == 0) {
            System.out.println("No input column indexes are given");
            return null;
        }
        Vector<Integer> Index = new Vector<Integer>();
        for (int i = 0; i < index.length; ++i) {
            if (index[i] > this.mnColumns || index[i] < 1) {
                System.out.println("Index out of bound");
                return null;
            }
            Index.add(new Integer(index[i] - 1));
        }
        if (Index.isEmpty()) {
            System.out.println("No valid column indexes are found");
            return null;
        }
        Vector<String> ColumnNames = new Vector<String>();
        Vector<String> ColumnValues = new Vector<String>();
        Vector<Integer> ColumnDefaults = new Vector<Integer>();
        for (int i = 0; i < Index.size(); ++i) {
            int nColumn = (Integer)Index.get(i);
            TreeSet<String> CurrentColumn = new TreeSet<String>();
            for (int j = 0; j < this.mnRows; ++j) {
                CurrentColumn.add(((String[])this.mColumns[nColumn])[j]);
            }
            int nCount = 0;
            while (!CurrentColumn.isEmpty()) {
                String str = (String)CurrentColumn.first();
                CurrentColumn.remove(str);
                ColumnNames.add(this.mColumnNames[nColumn]);
                ColumnValues.add(str);
                ColumnDefaults.add(new Integer(nCount));
                ++nCount;
            }
        }
        Object[] result = null;
        if (ColumnNames.size() > 0) {
            if (generateDefault) {
                result = new Object[3];
                result[2] = new String[ColumnNames.size()];
            } else {
                result = new Object[]{new String[ColumnNames.size()], new String[ColumnNames.size()]};
            }
            for (int i = 0; i < ((String[])result[0]).length; ++i) {
                ((String[])result[0])[i] = (String)ColumnNames.get(i);
                ((String[])result[1])[i] = (String)ColumnValues.get(i);
                if (!generateDefault) continue;
                ((String[])result[2])[i] = ((Integer)ColumnDefaults.get(i)).toString();
                if (!((String)ColumnValues.get(i)).equalsIgnoreCase(this.mstrMissingValue)) continue;
                ((String[])result[2])[i] = this.mstrMissingValue;
            }
        }
        String[] cNames = generateDefault ? new String[3] : new String[2];
        cNames[0] = "ColumnNames";
        cNames[1] = "OriginalValues";
        if (generateDefault) {
            cNames[2] = "NewValues";
        }
        return new TextArray(result, cNames);
    }

    public String[] datacolumnnames() {
        if (this.mdData != null) {
            int nColumn = this.mdData[0].length;
            if (nColumn == 0) {
                return null;
            }
            String[] result = new String[nColumn];
            int nCurrent = 0;
            for (int i = 0; i < this.mnType.length; ++i) {
                if (this.mnType[i] <= 0) continue;
                result[nCurrent] = this.mColumnNames[i];
                ++nCurrent;
            }
            return result;
        }
        return null;
    }

    public String keyj(int index) {
        return this.keym(index + 1);
    }

    public String[] columnnames() {
        return this.mColumnNames;
    }

    public String columnnamem(int index) {
        if (index < 1 || index > this.mnColumns) {
            System.out.println("Index out of bound");
            return null;
        }
        return this.mColumnNames[index - 1];
    }

    public String columnnamej(int index) {
        return this.columnnamem(index + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader getBufferedReader(String FileName) {
        void var1_2;
        BufferedReader br;
        File f = new File(FileName);
        if (f.exists()) {
            try {
                br = new BufferedReader(new FileReader(f));
            }
            catch (Exception e) {
                System.out.println(e.toString());
                return null;
            }
        }
        try {
            URL url = new URL(FileName);
            URLConnection conn = url.openConnection();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (Exception e) {
            System.out.println("Failed to open file " + FileName);
            System.out.println(e.toString());
            return null;
        }
        return var1_2;
    }

    public int getFieldCount(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        Vector cols = this.parseString(str);
        return cols.size();
    }

    private int[] getDimension(String FileName) {
        this.mnColumns = 0;
        this.mnRows = 0;
        int nLineCount = 0;
        int nColumnCount = 0;
        BufferedReader br = TextArray.getBufferedReader(FileName);
        if (br == null) {
            return null;
        }
        try {
            String str;
            int nIgnore = this.mnIgnore;
            while ((str = br.readLine()) != null) {
                if (str.trim().length() == 0) continue;
                if (nIgnore > 0) {
                    --nIgnore;
                    continue;
                }
                if (++nLineCount != 1) continue;
                Vector cols = this.parseString(str);
                nColumnCount = cols.size();
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
        int[] dim = new int[]{nLineCount, nColumnCount};
        this.mnRows = this.mbHeader ? dim[0] - 1 : dim[0];
        this.mnColumns = dim[1];
        return dim;
    }

    private Hashtable parseDuplicatedStringArray(String[] oa) {
        Hashtable<String, Vector> h = new Hashtable<String, Vector>(1000);
        if (oa.length > 0) {
            for (int i = 0; i < oa.length; ++i) {
                Vector Indexes;
                String str;
                if (oa[i] == null || (str = oa[i].trim()).length() <= 0) continue;
                if (h.containsKey(str)) {
                    Indexes = (Vector)h.get(str);
                    Indexes.addElement(new Integer(i));
                    h.put(str, Indexes);
                    continue;
                }
                Indexes = new Vector();
                Indexes.addElement(new Integer(i));
                h.put(str, Indexes);
            }
        }
        return h;
    }

    private Hashtable parseStringArray(String[] oa) {
        Hashtable<String, Integer> h = new Hashtable<String, Integer>(1000);
        if (oa.length > 0) {
            for (int i = 0; i < oa.length; ++i) {
                String str;
                if (oa[i] == null || (str = oa[i].trim()).length() <= 0) continue;
                h.put(str, new Integer(i));
            }
        }
        return h;
    }

    private void parseHeader(String str) {
        this.mColumnNames = new String[this.mnColumns];
        for (int i = 0; i < this.mnColumns; ++i) {
            this.mColumnNames[i] = new Integer(i + 1).toString();
        }
        if (this.mbHeader) {
            Vector cols = this.parseString(str);
            int ncolumn = 0;
            for (int i = 0; i < this.mnColumns; ++i) {
                this.mColumnNames[ncolumn] = i < cols.size() ? (String)cols.get(i) : this.mstrMissingValue;
                ++ncolumn;
            }
        }
    }

    private String[] parseString(String str, int size) {
        String[] result = new String[size];
        Vector cols = this.parseString(str);
        int ncolumn = 0;
        for (int i = 0; i < size; ++i) {
            result[ncolumn] = i < cols.size() ? (String)cols.get(i) : this.mstrMissingValue;
            ++ncolumn;
        }
        return result;
    }

    private void squeeze() {
        int[] naIndicators = new int[this.mnColumns];
        int nColumnCount = 0;
        block0: for (int j = 0; j < this.mnColumns; ++j) {
            String[] col = (String[])this.mColumns[j];
            naIndicators[j] = 1;
            for (int i = 0; i < this.mnRows; ++i) {
                if (col[i].equalsIgnoreCase(this.mstrMissingValue)) continue;
                naIndicators[j] = 0;
                ++nColumnCount;
                continue block0;
            }
        }
        if (nColumnCount != this.mnColumns) {
            System.out.println("Removing columns that contain only missing values...");
            Object[] columns = new Object[nColumnCount];
            String[] headers = new String[nColumnCount];
            int nCurrentColumn = 0;
            for (int j = 0; j < this.mnColumns; ++j) {
                if (naIndicators[j] >= 1) continue;
                columns[nCurrentColumn] = this.mColumns[j];
                headers[nCurrentColumn] = this.mColumnNames[j];
                ++nCurrentColumn;
            }
            this.createArray(columns, headers);
        }
    }

    private Vector parseString(String str) {
        Vector<String> result = new Vector<String>();
        if (this.mstrSeparator.equalsIgnoreCase(" \t\n\r\f")) {
            StringTokenizer st = new StringTokenizer(str, this.mstrSeparator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() == 0) {
                    token = this.mstrMissingValue;
                }
                result.add(token.trim());
            }
        } else {
            StringTokenizer st = new StringTokenizer(str, this.mstrSeparator, true);
            boolean bToken = false;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!bToken) {
                    bToken = token.equalsIgnoreCase(this.mstrSeparator);
                    if (bToken) {
                        token = this.mstrMissingValue;
                    }
                    result.add(token.trim());
                }
                bToken = !bToken;
            }
        }
        return result;
    }

    private void parseDataRow(String str, int nrow) {
        if (nrow >= 0 && nrow < this.mnRows) {
            Vector cols = this.parseString(str);
            int ncolumn = 0;
            for (int i = 0; i < this.mnColumns; ++i) {
                ((String[])this.mColumns[ncolumn])[nrow] = i < cols.size() ? (String)cols.get(i) : this.mstrMissingValue;
                ++ncolumn;
            }
        }
    }

    private boolean parseData(Object[] columns) {
        this.mColumns = new Object[this.mnColumns];
        for (int j = 0; j < this.mnColumns; ++j) {
            this.mColumns[j] = new String[this.mnRows];
            String[] col = (String[])columns[j];
            for (int i = 0; i < this.mnRows; ++i) {
                ((String[])this.mColumns[j])[i] = col[i] == null || col[i].trim().length() == 0 ? this.mstrMissingValue : col[i].trim();
            }
        }
        return true;
    }

    private boolean parseData(Object[] columns, String[] headers) {
        this.mColumnNames = new String[this.mnColumns];
        for (int i = 0; i < this.mnColumns; ++i) {
            this.mColumnNames[i] = new Integer(i + 1).toString();
        }
        if (this.mbHeader) {
            for (int j = 0; j < this.mnColumns; ++j) {
                this.mColumnNames[j] = headers[j] == null || headers[j].trim().length() == 0 ? this.mstrMissingValue : headers[j].trim();
            }
        }
        this.parseData(columns);
        return true;
    }

    private boolean parseData(String FileName) {
        BufferedReader br = TextArray.getBufferedReader(FileName);
        if (br == null) {
            return false;
        }
        this.mColumns = new Object[this.mnColumns];
        for (int i = 0; i < this.mnColumns; ++i) {
            this.mColumns[i] = new String[this.mnRows];
        }
        int nSkip = this.mbHeader ? 1 : 0;
        int nLineCount = 0;
        try {
            String str;
            int nIgnore = this.mnIgnore;
            while ((str = br.readLine()) != null) {
                if (str.trim().length() == 0) continue;
                if (nIgnore > 0) {
                    --nIgnore;
                    continue;
                }
                if (++nLineCount == 1) {
                    this.parseHeader(str);
                }
                int nrow = nLineCount - nSkip - 1;
                this.parseDataRow(str, nrow);
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    private void getType() {
        this.mnType = new int[this.mnColumns];
        block4: for (int j = 0; j < this.mnColumns; ++j) {
            this.mnType[j] = 1;
            for (int i = 0; i < this.mnRows; ++i) {
                block10: {
                    if (!((String[])this.mColumns[j])[i].equalsIgnoreCase(this.mstrMissingValue)) {
                        try {
                            double d = Double.parseDouble(((String[])this.mColumns[j])[i]);
                        }
                        catch (Exception e) {
                            if (((String[])this.mColumns[j])[i].length() <= 0) break block10;
                            this.mnType[j] = 0;
                        }
                    }
                }
                if (this.mnType[j] == 0) continue block4;
            }
        }
        SimpleDateFormat df = new SimpleDateFormat(this.mstrDateFormat);
        block6: for (int j = 0; j < this.mnColumns; ++j) {
            if (this.mnType[j] != 0) continue;
            this.mnType[j] = 2;
            for (int i = 0; i < this.mnRows; ++i) {
                block11: {
                    if (!((String[])this.mColumns[j])[i].equalsIgnoreCase(this.mstrMissingValue)) {
                        try {
                            Date date = df.parse(((String[])this.mColumns[j])[i]);
                        }
                        catch (Exception e) {
                            if (((String[])this.mColumns[j])[i].length() <= 0) break block11;
                            this.mnType[j] = 0;
                        }
                    }
                }
                if (this.mnType[j] == 0) continue block6;
            }
        }
    }

    public boolean hasUniqueKey() {
        if (this.mstrKey == null || this.mstrKey.length == 0) {
            return false;
        }
        Hashtable<String, Integer> keys = new Hashtable<String, Integer>(this.mstrKey.length);
        for (int i = 0; i < this.mstrKey.length; ++i) {
            if (keys.containsKey(this.mstrKey)) {
                return false;
            }
            keys.put(this.mstrKey[i], new Integer(i + 1));
        }
        return true;
    }

    public String getMissingValue() {
        return this.mstrMissingValue;
    }

    public String getSeparator() {
        return this.mstrSeparator;
    }

    public boolean getHeader() {
        return this.mbHeader;
    }

    private void analyze() {
        this.getType();
        int nDataColumns = 0;
        for (int j = 0; j < this.mnColumns; ++j) {
            if (this.mnType[j] <= 0) continue;
            ++nDataColumns;
        }
        this.mdData = nDataColumns == 0 ? (double[][])null : new double[this.mnRows][nDataColumns];
        this.mstrKey = new String[this.mnRows];
        int nDC = 0;
        SimpleDateFormat df = new SimpleDateFormat(this.mstrDateFormat);
        int nMissingCount = 0;
        for (int j = 0; j < this.mnColumns; ++j) {
            int i;
            if (j == 0) {
                for (i = 0; i < this.mnRows; ++i) {
                    this.mstrKey[i] = ((String[])this.mColumns[j])[i] != null && !((String[])this.mColumns[j])[i].equalsIgnoreCase(this.mstrMissingValue) ? ((String[])this.mColumns[j])[i] : new Integer(i + 1).toString();
                }
            }
            if (this.mnType[j] == 0) continue;
            if (this.mnType[j] == 1) {
                for (i = 0; i < this.mnRows; ++i) {
                    try {
                        this.mdData[i][nDC] = Double.parseDouble(((String[])this.mColumns[j])[i]);
                        continue;
                    }
                    catch (Exception e) {
                        this.mdData[i][nDC] = Double.NaN;
                        ++nMissingCount;
                    }
                }
                ++nDC;
                continue;
            }
            for (i = 0; i < this.mnRows; ++i) {
                try {
                    Date date = df.parse(((String[])this.mColumns[j])[i]);
                    this.mdData[i][nDC] = date.getTime() / 1000L / 60L / 60L / 24L;
                    continue;
                }
                catch (Exception e) {
                    this.mdData[i][nDC] = Double.NaN;
                    ++nMissingCount;
                }
            }
            ++nDC;
        }
    }

    public boolean load(String FileName) {
        this.mstrFileName = FileName;
        if (this.getDimension(FileName) == null) {
            return false;
        }
        if (!this.parseData(FileName)) {
            return false;
        }
        this.analyze();
        this.squeeze();
        return true;
    }

    public int[] size() {
        int[] result = new int[]{this.mnRows, this.mnColumns};
        return result;
    }
}

