/*
 * Decompiled with CFR 0.152.
 */
package dataframe;

import dataframe.ChipDescription;
import dataframe.Mapper;
import dataframe.TextArray;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class Tools {
    public static TextArray mergeCG(TextArray ClinInfo, TextArray GeneInfo) {
        Object[] result = Tools.mergeCG0(ClinInfo, GeneInfo);
        if (result == null) {
            return null;
        }
        return (TextArray)result[0];
    }

    public static TextArray alignClinNames(String map, String clinFile, String field) {
        TextArray taA = new TextArray(map, "\t", "NA", true);
        if (taA == null || taA.columnnames().length < 2) {
            System.out.println("Invalid clinical name map file");
            return null;
        }
        if (taA.columnm("STANDARD") == null || taA.columnm(field) == null) {
            System.out.println("Invalid clinical name map file");
            return null;
        }
        Mapper Map2 = new Mapper(taA.columnm("STANDARD"), taA.columnm(field));
        if (Map2.c1() == null || Map2.c1().length == 0) {
            System.out.println("Invalid clinical name map file");
            return null;
        }
        TextArray taB = new TextArray(clinFile, "\t", "NA", true);
        if (taB.columnnames() == null || taB.columnnames().length == 0) {
            System.out.println("Invalid clinical name map file");
            return null;
        }
        taB.transpose();
        Object[] result = Map2.align(taA, taB);
        if (result == null) {
            System.out.println("Failed to map clinical variable names");
            return null;
        }
        taA = (TextArray)result[0];
        taB = (TextArray)result[1];
        taB.transpose();
        taB.setColumnNames(taA.keys());
        return taB;
    }

    public static Object mergeCG(String ClinInfo, String GeneInfo, String output) {
        TextArray taClin = new TextArray(ClinInfo, "\t", "na", true);
        if (taClin == null) {
            System.out.println("Reading clinical information file " + ClinInfo + " failed");
            return null;
        }
        TextArray taGene = new TextArray(GeneInfo, "\t", "na", true);
        if (taGene == null) {
            System.out.println("Reading gene expression data file " + GeneInfo + " failed");
            return null;
        }
        TextArray result = Tools.mergeCG(taClin, taGene);
        if (result != null && output != null) {
            result.save(output, false, true, true);
        }
        return result;
    }

    public static TextArray mergeCC(TextArray c1, TextArray c2) {
        if (c1.columnnames() == null || c1.columnnames().length == 0) {
            System.out.println("Error: Invalid Input");
            return null;
        }
        if (c2.columnnames() == null || c2.columnnames().length == 0) {
            System.out.println("Error: Invalid Input");
            return null;
        }
        c1.transpose();
        c2.transpose();
        if (!c1.hasUniqueKey()) {
            System.out.println("Error: Clinical variables do not have unique names");
            return null;
        }
        if (!c2.hasUniqueKey()) {
            System.out.println("Error: Clinical variables do not have unique names");
            return null;
        }
        TextArray result = c1.merge(c2);
        c1.transpose();
        c2.transpose();
        if (result != null) {
            result.transpose();
            return result;
        }
        return null;
    }

    public static Object[] mergeCG0(TextArray ClinInfo, TextArray GeneInfo) {
        if (ClinInfo.columnnames() == null || ClinInfo.columnnames().length == 0) {
            System.out.println("Error: Invalid or incomplete clinical information");
            return null;
        }
        if (GeneInfo.columnnames() == null || GeneInfo.columnnames().length == 0) {
            System.out.println("Error: Invalid or incomplete geneexpression information");
            return null;
        }
        if (!ClinInfo.hasUniqueKey()) {
            System.out.println("Error: Clinical data does not have unique row identifiers(keys)");
            return null;
        }
        if (!ClinInfo.hasUniqueKey()) {
            System.out.println("Error: Gene expression data does not have unique row identifiers(keys)");
            return null;
        }
        GeneInfo.transpose();
        Object[] result = ClinInfo.merge0(GeneInfo);
        if (result != null) {
            ((TextArray)result[0]).transpose();
        }
        GeneInfo.transpose();
        return result;
    }

    public static boolean saveAsSvmFu(String gct, String cls, String result) {
        TextArray taA = new TextArray(gct, "tab", "na", true, 2);
        if (taA == null) {
            System.out.println("Loading gct file failed");
            return false;
        }
        TextArray taGCT = taA.getDataArray();
        if (taGCT == null || taGCT.columnnames() == null) {
            System.out.println("Loading gct file failed");
            return false;
        }
        TextArray taCLS = new TextArray(cls, "default", "na", false, 2);
        if (taCLS == null || taCLS.columnnames() == null) {
            System.out.println("Loading cls file failed");
            return false;
        }
        taCLS.transpose();
        if (taCLS.keys().length != taGCT.keys().length) {
            System.out.println("gct file and cls file do not match");
            return false;
        }
        double[][] clsdata = new double[taCLS.keys().length][1];
        for (int i = 0; i < clsdata.length; ++i) {
            clsdata[i][0] = taCLS.data()[i][0] == 0.0 ? -1.0 : 1.0;
        }
        TextArray taNewCLS = new TextArray(clsdata);
        TextArray res = taNewCLS.concatenate(taGCT, taNewCLS);
        String[] strHeader = new String[]{"" + taGCT.keys().length + "\t" + taGCT.columnnames().length};
        res.setHeaderLines(strHeader);
        return res.save(result, false, false, true);
    }

    public static boolean saveAsCLS(TextArray input, String FileName, String ColumnName) {
        if (input == null || input.columnnames() == null || input.columnnames().length == 0) {
            return false;
        }
        if (ColumnName == null || ColumnName.length() == 0) {
            return false;
        }
        int nColumnIndex = -1;
        for (int i = 0; i < input.columnnames().length; ++i) {
            if (!input.columnnamej(i).equalsIgnoreCase(ColumnName)) continue;
            nColumnIndex = i;
            break;
        }
        if (nColumnIndex >= 0) {
            int[] index = new int[]{nColumnIndex + 1};
            TextArray column = input.createCodeTablem(index, false);
            if (column == null || column.columnnames().length == 0) {
                return false;
            }
            String[] values = column.columnj(1);
            if (values == null || values.length == 0) {
                return false;
            }
            try {
                BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
                fw.write(new Integer(input.columnj(nColumnIndex).length).toString());
                fw.write(" ");
                fw.write(new Integer(values.length).toString());
                fw.write(" 1");
                fw.newLine();
                fw.write("# ");
                fw.write(values[0]);
                for (int i = 1; i < values.length; ++i) {
                    fw.write(" ");
                    fw.write(values[i]);
                }
                fw.newLine();
                fw.write(input.columnj(nColumnIndex)[0]);
                for (int j = 1; j < input.columnj(nColumnIndex).length; ++j) {
                    fw.write(" ");
                    fw.write(input.columnj(nColumnIndex)[j]);
                }
                fw.flush();
                fw.close();
            }
            catch (IOException e) {
                System.out.println("Save file " + FileName + " failed");
                return false;
            }
            return true;
        }
        System.out.println(ColumnName + " not found");
        return false;
    }

    public static boolean saveAsGCT(TextArray input, String FileName) {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
            fw.write("#1.2");
            fw.newLine();
            fw.write(new Integer(input.keys().length).toString());
            fw.write("\t");
            fw.write(new Integer(input.datacolumnnames().length).toString());
            fw.newLine();
            if (input.columnnames().length > 0) {
                int i;
                fw.write(input.columnnames()[0]);
                for (i = 1; i < input.columnnames().length; ++i) {
                    fw.write("\t");
                    fw.write(input.columnnames()[i]);
                }
                fw.newLine();
                if (input.keys().length > 0) {
                    for (i = 0; i < input.keys().length; ++i) {
                        fw.write(input.columnj(0)[i]);
                        for (int j = 1; j < input.columnnames().length; ++j) {
                            fw.write("\t");
                            fw.write(input.columnj(j)[i]);
                        }
                        if (i == input.keys().length - 1) continue;
                        fw.newLine();
                    }
                }
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Save file " + FileName + " failed");
            return false;
        }
        return true;
    }

    public static TextArray makeTextArray(String DataFile, String ChipIDFullNameFile, String GeneDescriptorsFile) {
        return Tools.makeTextArray(DataFile, ChipIDFullNameFile, GeneDescriptorsFile, "default", "default", "tab");
    }

    public static TextArray normaliseClinKeys(String mapfile, String clinfile, int c1, int c2) {
        TextArray d = new TextArray(clinfile, "tab", "NaN", true);
        Mapper m = new Mapper();
        m.set("tab", 1, c1, c2);
        m.load(mapfile, 1);
        TextArray c = new TextArray(mapfile, "tab", "NaN", true);
        Object[] result = m.align(c, d);
        if (result == null) {
            return null;
        }
        d = (TextArray)result[1];
        d.replaceKeys(((TextArray)result[0]).columnm(1));
        return d;
    }

    public static TextArray makeTextArray(String DataFile, String ChipIDFullNameFile, String GeneDescriptorsFile, String sep1, String sep2, String sep3) {
        System.out.println("Loading data...");
        TextArray data = new TextArray(DataFile, sep1, "NA", false);
        if (data.columnnames() == null || data.columns().length == 0) {
            System.out.println("Invalid data file");
            return null;
        }
        if (data.datacolumnnames() == null || data.datacolumnnames().length != data.columnnames().length) {
            System.out.println("Invalid data file");
            return null;
        }
        System.out.println("loading gene descriptors...");
        ChipDescription desc = new ChipDescription("unknown", GeneDescriptorsFile, 0);
        if (desc.getID() == null || desc.getID().length == 0) {
            System.out.println("Invalid genedescriptors file");
            return null;
        }
        if (desc.getID().length != data.keys().length) {
            System.out.println("The number of rows of data matrix must match the number of rows of genedescriptors file");
            return null;
        }
        TextArray taA = desc.toTextArray(true);
        System.out.println("loading chipid.fullname file...");
        TextArray ChipInfo = new TextArray(ChipIDFullNameFile, sep3, "NA", false);
        if (ChipInfo.columnnames() == null || ChipInfo.columnnames().length == 0) {
            System.out.println("Invalid chipid.fullname file");
            return null;
        }
        if (ChipInfo.datacolumnnames() != null && ChipInfo.datacolumnnames().length > 0) {
            int nCount = 0;
            for (int i = 0; i < ChipInfo.keys().length; ++i) {
                if (!(ChipInfo.data()[i][0] > 0.0)) continue;
                ++nCount;
            }
            if (nCount != data.columnnames().length) {
                System.out.println("The number of samples used in chipid.fullname file must match the number of columns of data matrix file");
                return null;
            }
            String[] strNames = new String[nCount];
            nCount = 0;
            for (int i = 0; i < ChipInfo.keys().length; ++i) {
                if (!(ChipInfo.data()[i][0] > 0.0)) continue;
                strNames[nCount] = ChipInfo.keyj(i);
                ++nCount;
            }
            data.setColumnNames(strNames);
        } else {
            if (ChipInfo.keys().length != data.columnnames().length) {
                System.out.println("The number of samples in chipid.fullname file must match the number of columns of data matrix file");
                return null;
            }
            data.setColumnNames(ChipInfo.keys());
        }
        System.out.println("merge files...");
        TextArray taC = taA.concatenate(taA, data);
        System.out.println("Done.");
        return taC;
    }
}

