/*
 * Decompiled with CFR 0.152.
 */
package sss;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import sss.ModelDialog;

public class Model {
    public static int BINREG = 2;
    public static int LINREG = 1;
    public static int SURVMODE = 3;
    protected boolean mbNoisy = true;
    protected boolean mbNormstand = true;
    protected boolean mbOnevar = true;
    protected double mdInnerAnnealAdd = 1.0;
    protected double mdInnerAnnealDelete = 0.8;
    protected double mdInnerAnnealReplace = 0.6;
    protected double mdOuterAnneal = 0.4;
    protected double mdPenalty = 4.0;
    protected int mnDstart = 2;
    protected int mnIters = 1000;
    protected int mnKMax = 4;
    protected int mnModtype = BINREG;
    protected int mnNBest = 5000;
    protected int mnNobservations = 0;
    protected int mnNvariables = 0;
    private ModelDialog modeldialog = null;
    protected String mstrDataFile = "data.txt";
    protected String mstrErrorMessage = "";
    protected String mstrIterOutFile = "iterout.txt";
    protected String mstrModelFile = "";
    protected String mstrModelSearch = "modelsearch.exe";
    protected String mstrModelSummary = "modelsummary.exe";
    protected String mstrOutFile = "models.txt";
    protected String mstrResponseFile = "responses.txt";
    protected String mstrSummaryFile = "modelsummary.txt";
    protected String mstrWeightsFile = "weights.txt";
    protected String mstrCensorshipFile = "NA";

    public String getDataFile() {
        return this.mstrDataFile;
    }

    public int getDStart() {
        return this.mnDstart;
    }

    public double getInnerAnnealAdd() {
        return this.mdInnerAnnealAdd;
    }

    public double getInnerAnnealDelete() {
        return this.mdInnerAnnealDelete;
    }

    public double getInnerAnnealReplace() {
        return this.mdInnerAnnealReplace;
    }

    public int getIterations() {
        return this.mnIters;
    }

    public String getIterOutFile() {
        return this.mstrIterOutFile;
    }

    public int getKMax() {
        return this.mnKMax;
    }

    public String getModelSearchProgram() {
        return this.mstrModelSearch;
    }

    public String getModelSummaryProgram() {
        return this.mstrModelSummary;
    }

    public int getModelType() {
        return this.mnModtype;
    }

    public int getNBest() {
        return this.mnNBest;
    }

    public int getNObservations() {
        return this.mnNobservations;
    }

    public boolean getNoisy() {
        return this.mbNoisy;
    }

    public boolean getNormStand() {
        return this.mbNormstand;
    }

    public int getNVariables() {
        return this.mnNvariables;
    }

    public boolean getOneVar() {
        return this.mbOnevar;
    }

    public double getOuterAnneal() {
        return this.mdOuterAnneal;
    }

    public String getOutputFile() {
        return this.mstrOutFile;
    }

    public double getPenalty() {
        return this.mdPenalty;
    }

    public String getResponseFile() {
        return this.mstrResponseFile;
    }

    public String getRunSearch() {
        return "!" + this.getModelSearchProgram() + "  " + "\"" + this.getSettingFile() + "\"";
    }

    public String getRunSummarize() {
        return "!" + this.getModelSummaryProgram() + "  " + "\"" + this.getSettingFile() + "\"";
    }

    public String getSettingFile() {
        return this.mstrModelFile;
    }

    public String getSummaryFile() {
        return this.mstrSummaryFile;
    }

    public String getWeightsFile() {
        return this.mstrWeightsFile;
    }

    public String getCensorshipFile() {
        return this.mstrCensorshipFile;
    }

    public void setDataFile(String s) {
        this.mstrDataFile = s;
    }

    public void setCensorshipFile(String s) {
        this.mstrCensorshipFile = s;
    }

    public void setDStart(int n) {
        this.mnDstart = n;
    }

    public void setInnerAnnealAdd(double d) {
        this.mdInnerAnnealAdd = d;
    }

    public void setInnerAnnealDelete(double d) {
        this.mdInnerAnnealDelete = d;
    }

    public void setInnerAnnealReplace(double d) {
        this.mdInnerAnnealReplace = d;
    }

    public void setIterations(int n) {
        this.mnIters = n;
    }

    public void setIterOutFile(String s) {
        this.mstrIterOutFile = s;
    }

    public void setKMax(int n) {
        this.mnKMax = n;
    }

    public void setModelSearchProgram(String s) {
        this.mstrModelSearch = s;
    }

    public void setModelSummaryProgram(String s) {
        this.mstrModelSummary = s;
    }

    public void setModelType(int n) {
        this.mnModtype = n;
    }

    public void setNBest(int n) {
        this.mnNBest = n;
    }

    public void setNObservations(int n) {
        this.mnNobservations = n;
    }

    public void setNoisy(boolean b) {
        this.mbNoisy = b;
    }

    public void setNormStand(boolean b) {
        this.mbNormstand = b;
    }

    public void setNVariables(int n) {
        this.mnNvariables = n;
    }

    public void setOneVar(boolean b) {
        this.mbOnevar = b;
    }

    public void setOuterAnneal(double d) {
        this.mdOuterAnneal = d;
    }

    public void setOutputFile(String s) {
        this.mstrOutFile = s;
    }

    public void setPenalty(double d) {
        this.mdPenalty = d;
    }

    public void setResponseFile(String s) {
        this.mstrResponseFile = s;
    }

    public void setSettingFile(String s) {
        this.mstrModelFile = s;
    }

    public void setSummaryFile(String s) {
        this.mstrSummaryFile = s;
    }

    public void setWeightsFile(String s) {
        this.mstrWeightsFile = s;
    }

    public static void main(String[] args) {
        Model model = new Model();
        model.start();
    }

    public boolean load(String FileName) {
        if (FileName == null) {
            return true;
        }
        File f = new File(FileName);
        if (!f.exists()) {
            this.mstrErrorMessage = "Failed to open the model file!";
            return false;
        }
        try {
            String theLine;
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((theLine = br.readLine()) != null) {
                String Name = "";
                String Value = "";
                theLine = theLine.trim();
                if ((theLine = Model.removeSpace(theLine)).length() <= 0 || theLine.startsWith("#")) continue;
                int eq = theLine.indexOf(61);
                if (eq == -1) {
                    this.mstrErrorMessage = "Invalid <Name = Value> pair format";
                    return false;
                }
                Name = theLine.substring(0, eq).trim();
                Value = theLine.substring(eq + 1).trim();
                String name = Name.toLowerCase();
                String value = Value.toLowerCase();
                if (name.equals("datafile")) {
                    this.mstrDataFile = Value;
                } else if (name.equals("responsefile")) {
                    this.mstrResponseFile = Value;
                } else if (name.equals("weightsfile")) {
                    this.mstrWeightsFile = Value;
                } else if (name.equals("outfile")) {
                    this.mstrOutFile = Value;
                } else if (name.equals("iterout")) {
                    this.mstrIterOutFile = Value;
                } else if (name.equals("summaryfile")) {
                    this.mstrSummaryFile = Value;
                } else if (name.equals("censorfile")) {
                    this.mstrCensorshipFile = Value;
                } else if (name.equals("nobservations")) {
                    this.mnNobservations = new Integer(value);
                } else if (name.equals("nvariables")) {
                    this.mnNvariables = new Integer(value);
                } else if (name.equals("noisy") || name.equals("debugout")) {
                    this.mbNoisy = Value.equals("1");
                } else if (name.equals("normstand")) {
                    this.mbNormstand = Value.equals("1");
                } else if (name.equals("dstart") || name.equals("pstart")) {
                    this.mnDstart = new Integer(value);
                } else if (name.equals("onevar")) {
                    this.mbOnevar = Value.equals("1");
                } else if (name.equals("modtype")) {
                    this.mnModtype = new Integer(value);
                } else if (name.equals("iters")) {
                    this.mnIters = new Integer(value);
                } else if (name.equals("nbest")) {
                    this.mnNBest = new Integer(value);
                } else if (name.equals("kmax") || name.equals("pmax")) {
                    this.mnKMax = new Integer(value);
                } else if (name.equals("inneranneal1")) {
                    this.mdInnerAnnealReplace = new Double(Value);
                } else if (name.equals("inneranneal3")) {
                    this.mdInnerAnnealAdd = new Double(Value);
                } else if (name.equals("inneranneal2")) {
                    this.mdInnerAnnealDelete = new Double(Value);
                } else if (name.equals("outeranneal")) {
                    this.mdOuterAnneal = new Double(Value);
                } else if (name.equals("penalty") || name.equals("priormeanp")) {
                    this.mdPenalty = new Double(Value);
                } else {
                    this.mstrErrorMessage = "Unknown <Name = Value> pair!";
                    return false;
                }
                this.mstrErrorMessage = "";
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        this.mstrModelFile = FileName;
        return true;
    }

    public void save(String FileName) {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
            fw.write("NOBSERVATIONS = ");
            fw.write(new Integer(this.mnNobservations).toString());
            fw.newLine();
            fw.write("NVARIABLES = ");
            fw.write(new Integer(this.mnNvariables).toString());
            fw.newLine();
            fw.write("DATAFILE = ");
            fw.write(this.mstrDataFile);
            fw.newLine();
            fw.write("OUTFILE = ");
            fw.write(this.mstrOutFile);
            fw.newLine();
            fw.write("RESPONSEFILE = ");
            fw.write(this.mstrResponseFile);
            fw.newLine();
            fw.write("WEIGHTSFILE = ");
            fw.write(this.mstrWeightsFile);
            fw.newLine();
            fw.write("ITEROUT = ");
            fw.write(this.mstrIterOutFile);
            fw.newLine();
            fw.write("SUMMARYFILE = ");
            fw.write(this.mstrSummaryFile);
            fw.newLine();
            fw.write("CENSORFILE = ");
            fw.write(this.mstrCensorshipFile);
            fw.newLine();
            fw.write("DEBUGOUT = ");
            if (this.mbNoisy) {
                fw.write("1");
            } else {
                fw.write("0");
            }
            fw.newLine();
            fw.write("NORMSTAND = ");
            if (this.mbNormstand) {
                fw.write("1");
            } else {
                fw.write("0");
            }
            fw.newLine();
            fw.write("PSTART = ");
            fw.write(new Integer(this.mnDstart).toString());
            fw.newLine();
            fw.write("ONEVAR = ");
            if (this.mbOnevar) {
                fw.write("1");
            } else {
                fw.write("0");
            }
            fw.newLine();
            fw.write("modtype = ");
            fw.write(new Integer(this.mnModtype).toString());
            fw.newLine();
            fw.write("iters = ");
            fw.write(new Integer(this.mnIters).toString());
            fw.newLine();
            fw.write("NBest = ");
            fw.write(new Integer(this.mnNBest).toString());
            fw.newLine();
            fw.write("pmax = ");
            fw.write(new Integer(this.mnKMax).toString());
            fw.newLine();
            fw.write("innerAnneal1 = ");
            fw.write(new Double(this.mdInnerAnnealReplace).toString());
            fw.newLine();
            fw.write("innerAnneal2 = ");
            fw.write(new Double(this.mdInnerAnnealDelete).toString());
            fw.newLine();
            fw.write("innerAnneal3 = ");
            fw.write(new Double(this.mdInnerAnnealAdd).toString());
            fw.newLine();
            fw.write("outerAnneal = ");
            fw.write(new Double(this.mdOuterAnneal).toString());
            fw.newLine();
            fw.write("priorMeanP = ");
            fw.write(new Double(this.mdPenalty).toString());
            fw.newLine();
            fw.flush();
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mstrModelFile = FileName;
    }

    public static String removeSpace(String v) {
        if (v.length() > 0) {
            String nv = "";
            for (int i = 0; i < v.length(); ++i) {
                if (v.charAt(i) == ' ' || v.charAt(i) == '\t') continue;
                nv = nv + v.charAt(i);
            }
            return nv;
        }
        return v;
    }

    public void runSearch() {
        try {
            Process child = Runtime.getRuntime().exec(this.getModelSearchProgram() + "  " + "\"" + this.getSettingFile() + "\"");
            child.waitFor();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void runSummarize() {
        try {
            Runtime.getRuntime().exec(this.getModelSummaryProgram() + "  " + "\"" + this.getSettingFile() + "\"");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void save() {
        if (this.mstrModelFile != null && this.mstrModelFile.length() != 0) {
            this.save(this.mstrModelFile);
        } else {
            System.out.println("File name not provided");
        }
    }

    public void start(String FileName) {
        this.load(FileName);
        if (this.modeldialog == null) {
            this.modeldialog = new ModelDialog(null, false, this);
        }
        this.update();
        this.modeldialog.show();
        this.modeldialog.toFront();
    }

    public void start() {
        this.start(null);
    }

    public void update() {
        if (this.modeldialog != null) {
            this.modeldialog.initValues();
        }
    }
}

