/*
 * Decompiled with CFR 0.152.
 */
package sss;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sss.Model;

public class ModelDialog
extends JDialog {
    private Model m;
    private String CurrentPath;
    private Matlab matlab;
    private String mstrModelFile;
    private boolean useMatlab;
    private JButton CancelButton;
    private JButton CensorshipFileButton;
    private JButton DataFileButton;
    private JButton IterFileButton;
    private JButton LoadButton;
    private JComboBox ModTypeComboBox;
    private JCheckBox NoisyCheckBox;
    private JButton OKButton;
    private JCheckBox OnevarCheckBox;
    private JButton OutFileButton;
    private JButton ResponseFileButton;
    private JButton RunButton;
    private JButton SaveButton;
    private JButton StopButton;
    private JButton SummaryFileButton;
    private JButton WeightFileButton;
    private JLabel lCensorshipFile;
    private JLabel lDStart;
    private JLabel lDataFile;
    private JLabel lInnerAnneal1;
    private JLabel lInnerAnneal2;
    private JLabel lInnerAnneal3;
    private JLabel lIterFile;
    private JLabel lKMax;
    private JLabel lModType;
    private JLabel lNBest;
    private JLabel lNIter;
    private JLabel lNObservations;
    private JLabel lNVariables;
    private JLabel lOutFile;
    private JLabel lOuterAnneal;
    private JLabel lPenalty;
    private JLabel lResponseFile;
    private JLabel lSummaryFile;
    private JLabel lWeightFile;
    private JPanel pData;
    private JPanel pOutput;
    private JPanel pParameters;
    private JTextField tCensorshipFile;
    private JTextField tDStart;
    private JTextField tDataFile;
    private JTextField tInnerAnneal1;
    private JTextField tInnerAnneal2;
    private JTextField tInnerAnneal3;
    private JTextField tIterFile;
    private JTextField tKMax;
    private JTextField tNBest;
    private JTextField tNIter;
    private JTextField tNObservations;
    private JTextField tNVariables;
    private JTextField tOutFile;
    private JTextField tOuterAnneal;
    private JTextField tPenalty;
    private JTextField tResponseFile;
    private JTextField tSummaryFile;
    private JTextField tWeightFile;

    public ModelDialog(JFrame parent, boolean modal, Model m) {
        super((Frame)parent, modal);
        this.m = m;
        this.initComponents();
        this.initValues();
        this.StopButton.setEnabled(false);
        this.RunButton.setEnabled(true);
        this.useMatlab = false;
        try {
            try {
                Class<?> cls = Class.forName("com.mathworks.jmi.Matlab");
                this.matlab = new Matlab();
                this.useMatlab = true;
                MatlabPath.addActionListener((ActionListener)new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        String s = ev.getActionCommand();
                        if (s != null && s.equals("CWD_CHANGE")) {
                            ModelDialog.this.CurrentPath = MatlabPath.getCWD();
                        }
                    }
                });
            }
            catch (ClassNotFoundException e) {}
        }
        catch (Exception e) {
            this.matlab = null;
            this.CurrentPath = ".";
        }
        this.mstrModelFile = m.getSettingFile();
    }

    private boolean validateInput() {
        String text = this.tNObservations.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Total Number Of Observation: must provide a value");
            return false;
        }
        try {
            int nNObs = Integer.parseInt(text);
            this.m.setNObservations(nNObs);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Total Number Of Observation: must be an integer");
            return false;
        }
        text = this.tNVariables.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Number Of Variables: must provide a value");
            return false;
        }
        try {
            int nNVars = Integer.parseInt(text);
            this.m.setNVariables(nNVars);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Number Of Variables: must be an integer");
            return false;
        }
        text = this.tDataFile.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Data File: must provide a value");
            return false;
        }
        this.m.setDataFile(text);
        text = this.tResponseFile.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Responses File: must provide a value");
            return false;
        }
        this.m.setResponseFile(text);
        text = this.tWeightFile.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Weights File: must provide a value");
            return false;
        }
        this.m.setWeightsFile(text);
        text = this.tOutFile.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Models File: must provide a value");
            return false;
        }
        this.m.setOutputFile(text);
        text = this.tIterFile.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Iteration Log File: must provide a value");
            return false;
        }
        this.m.setIterOutFile(text);
        text = this.tSummaryFile.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Model Summary File: must provide a value");
            return false;
        }
        this.m.setSummaryFile(text);
        this.m.setNoisy(this.NoisyCheckBox.isSelected());
        this.m.setModelType(this.ModTypeComboBox.getSelectedIndex() + 1);
        text = this.tDStart.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Initial Model Size: must provide a value");
            return false;
        }
        try {
            int nDStart = Integer.parseInt(text);
            this.m.setDStart(nDStart);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Initial Model Size: must be an integer");
            return false;
        }
        text = this.tKMax.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Maximum Model Size: must provide a value");
            return false;
        }
        try {
            int nKMax = Integer.parseInt(text);
            this.m.setKMax(nKMax);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Maximum Model Size: must be an integer");
            return false;
        }
        text = this.tPenalty.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Penalty Value: must provide a value");
            return false;
        }
        try {
            double dPenalty = Double.parseDouble(text);
            this.m.setPenalty(dPenalty);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Penalty Value: must be a real number");
            return false;
        }
        text = this.tNBest.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Number Of Best Models: must provide a value");
            return false;
        }
        try {
            int nNBest = Integer.parseInt(text);
            this.m.setNBest(nNBest);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Number Of Best Models: must be an integer");
            return false;
        }
        text = this.tNIter.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Number Of Iterations: must provide a value");
            return false;
        }
        try {
            int nNIter = Integer.parseInt(text);
            this.m.setIterations(nNIter);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Number Of Iterations: must be an integer");
            return false;
        }
        text = this.tInnerAnneal1.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(replace): must provide a value");
            return false;
        }
        try {
            double dInnerAnneal1 = Double.parseDouble(text);
            this.m.setInnerAnnealReplace(dInnerAnneal1);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(replace): must be a real number");
            return false;
        }
        text = this.tInnerAnneal2.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(add): must provide a value");
            return false;
        }
        try {
            double dInnerAnneal2 = Double.parseDouble(text);
            this.m.setInnerAnnealAdd(dInnerAnneal2);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(add): must be a real number");
            return false;
        }
        text = this.tInnerAnneal3.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(delete): must provide a value");
            return false;
        }
        try {
            double dInnerAnneal3 = Double.parseDouble(text);
            this.m.setInnerAnnealDelete(dInnerAnneal3);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(delete): must be a real number");
            return false;
        }
        text = this.tOuterAnneal.getText();
        if (text == null || text.length() == 0) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(outer): must provide a value");
            return false;
        }
        try {
            double dOuterAnneal = Double.parseDouble(text);
            this.m.setOuterAnneal(dOuterAnneal);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Annealing Parameter(delete): must be a real number");
            return false;
        }
        text = this.tCensorshipFile.getText();
        if ((text == null || text.length() == 0) && this.ModTypeComboBox.getSelectedIndex() == 2) {
            JOptionPane.showMessageDialog(null, "Censorship File: must provide a value");
            return false;
        }
        this.m.setCensorshipFile(text);
        this.m.setOneVar(this.OnevarCheckBox.isSelected());
        return true;
    }

    public void initValues() {
        if (this.m != null) {
            this.tNObservations.setText(Integer.toString(this.m.getNObservations()));
            this.tNVariables.setText(Integer.toString(this.m.getNVariables()));
            this.tDataFile.setText(this.m.getDataFile());
            this.tResponseFile.setText(this.m.getResponseFile());
            this.tWeightFile.setText(this.m.getWeightsFile());
            this.tOutFile.setText(this.m.getOutputFile());
            this.tIterFile.setText(this.m.getIterOutFile());
            this.tSummaryFile.setText(this.m.getSummaryFile());
            this.tCensorshipFile.setText(this.m.getCensorshipFile());
            this.NoisyCheckBox.setSelected(this.m.getNoisy());
            this.ModTypeComboBox.setSelectedIndex(this.m.getModelType() - 1);
            this.tDStart.setText(Integer.toString(this.m.getDStart()));
            this.tKMax.setText(Integer.toString(this.m.getKMax()));
            this.tPenalty.setText(Double.toString(this.m.getPenalty()));
            this.tNBest.setText(Integer.toString(this.m.getNBest()));
            this.tNIter.setText(Integer.toString(this.m.getIterations()));
            this.tInnerAnneal1.setText(Double.toString(this.m.getInnerAnnealReplace()));
            this.tInnerAnneal2.setText(Double.toString(this.m.getInnerAnnealAdd()));
            this.tInnerAnneal3.setText(Double.toString(this.m.getInnerAnnealDelete()));
            this.tOuterAnneal.setText(Double.toString(this.m.getOuterAnneal()));
            this.OnevarCheckBox.setSelected(this.m.getOneVar());
        }
        this.ToggleCheckBox();
    }

    private void initComponents() {
        this.pData = new JPanel();
        this.lNObservations = new JLabel();
        this.tNObservations = new JTextField();
        this.lNVariables = new JLabel();
        this.tNVariables = new JTextField();
        this.lDataFile = new JLabel();
        this.tDataFile = new JTextField();
        this.DataFileButton = new JButton();
        this.lResponseFile = new JLabel();
        this.tResponseFile = new JTextField();
        this.ResponseFileButton = new JButton();
        this.lWeightFile = new JLabel();
        this.tWeightFile = new JTextField();
        this.WeightFileButton = new JButton();
        this.lCensorshipFile = new JLabel();
        this.tCensorshipFile = new JTextField();
        this.CensorshipFileButton = new JButton();
        this.pParameters = new JPanel();
        this.OnevarCheckBox = new JCheckBox();
        this.lDStart = new JLabel();
        this.tDStart = new JTextField();
        this.lModType = new JLabel();
        this.ModTypeComboBox = new JComboBox();
        this.lKMax = new JLabel();
        this.tKMax = new JTextField();
        this.lPenalty = new JLabel();
        this.tPenalty = new JTextField();
        this.lNBest = new JLabel();
        this.tNBest = new JTextField();
        this.lInnerAnneal1 = new JLabel();
        this.tInnerAnneal1 = new JTextField();
        this.lInnerAnneal2 = new JLabel();
        this.tInnerAnneal2 = new JTextField();
        this.lInnerAnneal3 = new JLabel();
        this.tInnerAnneal3 = new JTextField();
        this.lOuterAnneal = new JLabel();
        this.tOuterAnneal = new JTextField();
        this.lNIter = new JLabel();
        this.tNIter = new JTextField();
        this.pOutput = new JPanel();
        this.lOutFile = new JLabel();
        this.tOutFile = new JTextField();
        this.OutFileButton = new JButton();
        this.lIterFile = new JLabel();
        this.tIterFile = new JTextField();
        this.IterFileButton = new JButton();
        this.lSummaryFile = new JLabel();
        this.tSummaryFile = new JTextField();
        this.SummaryFileButton = new JButton();
        this.NoisyCheckBox = new JCheckBox();
        this.LoadButton = new JButton();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.RunButton = new JButton();
        this.StopButton = new JButton();
        this.SaveButton = new JButton();
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.setTitle("Model Search");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ModelDialog.this.closeDialog(evt);
            }
        });
        this.pData.setLayout((LayoutManager)new AbsoluteLayout());
        this.pData.setBorder(new TitledBorder(null, "Input", 0, 0, new Font("Dialog", 1, 11)));
        this.lNObservations.setFont(new Font("Dialog", 0, 12));
        this.lNObservations.setText("Total Number Of Observations: ");
        this.lNObservations.setToolTipText("");
        this.pData.add((Component)this.lNObservations, new AbsoluteConstraints(10, 20, 200, 20));
        this.pData.add((Component)this.tNObservations, new AbsoluteConstraints(220, 20, 90, -1));
        this.lNVariables.setFont(new Font("Dialog", 0, 12));
        this.lNVariables.setText("Number Of Variables:");
        this.lNVariables.setToolTipText("\n\n");
        this.pData.add((Component)this.lNVariables, new AbsoluteConstraints(10, 40, 210, 20));
        this.tNVariables.setToolTipText("");
        this.pData.add((Component)this.tNVariables, new AbsoluteConstraints(220, 40, 90, -1));
        this.lDataFile.setFont(new Font("Dialog", 0, 12));
        this.lDataFile.setText("Data File:");
        this.pData.add((Component)this.lDataFile, new AbsoluteConstraints(10, 60, 150, -1));
        this.pData.add((Component)this.tDataFile, new AbsoluteConstraints(160, 60, 200, -1));
        this.DataFileButton.setFont(new Font("Dialog", 0, 12));
        this.DataFileButton.setText(" ...");
        this.DataFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.DataFileButtonActionPerformed(evt);
            }
        });
        this.pData.add((Component)this.DataFileButton, new AbsoluteConstraints(360, 60, 20, 20));
        this.lResponseFile.setFont(new Font("Dialog", 0, 12));
        this.lResponseFile.setText("Responses File:");
        this.pData.add((Component)this.lResponseFile, new AbsoluteConstraints(10, 80, 150, -1));
        this.pData.add((Component)this.tResponseFile, new AbsoluteConstraints(160, 80, 200, -1));
        this.ResponseFileButton.setFont(new Font("Dialog", 0, 12));
        this.ResponseFileButton.setText(" ...");
        this.ResponseFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.ResponseFileButtonActionPerformed(evt);
            }
        });
        this.pData.add((Component)this.ResponseFileButton, new AbsoluteConstraints(360, 80, 20, 20));
        this.lWeightFile.setFont(new Font("Dialog", 0, 12));
        this.lWeightFile.setText("Weights File:");
        this.pData.add((Component)this.lWeightFile, new AbsoluteConstraints(10, 100, 150, -1));
        this.tWeightFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.tWeightFileActionPerformed(evt);
            }
        });
        this.pData.add((Component)this.tWeightFile, new AbsoluteConstraints(160, 100, 200, -1));
        this.WeightFileButton.setFont(new Font("Dialog", 0, 12));
        this.WeightFileButton.setText(" ...");
        this.WeightFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.WeightFileButtonActionPerformed(evt);
            }
        });
        this.pData.add((Component)this.WeightFileButton, new AbsoluteConstraints(360, 100, 20, 20));
        this.lCensorshipFile.setFont(new Font("Dialog", 0, 12));
        this.lCensorshipFile.setText("Censorship File:");
        this.pData.add((Component)this.lCensorshipFile, new AbsoluteConstraints(10, 120, 150, 20));
        this.pData.add((Component)this.tCensorshipFile, new AbsoluteConstraints(160, 120, 200, -1));
        this.CensorshipFileButton.setFont(new Font("Dialog", 0, 12));
        this.CensorshipFileButton.setText(" ...");
        this.CensorshipFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.CensorshipFileButtonActionPerformed(evt);
            }
        });
        this.pData.add((Component)this.CensorshipFileButton, new AbsoluteConstraints(360, 120, 20, 20));
        this.getContentPane().add((Component)this.pData, new AbsoluteConstraints(10, 10, 390, 150));
        this.pParameters.setLayout((LayoutManager)new AbsoluteLayout());
        this.pParameters.setBorder(new TitledBorder(null, "Parameters", 0, 0, new Font("Dialog", 1, 11)));
        this.OnevarCheckBox.setFont(new Font("Dialog", 0, 12));
        this.OnevarCheckBox.setSelected(true);
        this.OnevarCheckBox.setText("Includes one variable model");
        this.pParameters.add((Component)this.OnevarCheckBox, new AbsoluteConstraints(10, 220, 280, -1));
        this.lDStart.setFont(new Font("Dialog", 0, 12));
        this.lDStart.setText("Initial Model Size:");
        this.pParameters.add((Component)this.lDStart, new AbsoluteConstraints(10, 40, 170, -1));
        this.pParameters.add((Component)this.tDStart, new AbsoluteConstraints(230, 40, 70, -1));
        this.lModType.setFont(new Font("Dialog", 0, 12));
        this.lModType.setText("Model Type:");
        this.pParameters.add((Component)this.lModType, new AbsoluteConstraints(10, 20, 170, -1));
        this.ModTypeComboBox.setFont(new Font("Dialog", 0, 11));
        this.ModTypeComboBox.setMaximumRowCount(3);
        this.ModTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Linear Regression", "Binary Regression", "Survival Analysis"}));
        this.pParameters.add((Component)this.ModTypeComboBox, new AbsoluteConstraints(180, 20, 120, 20));
        this.lKMax.setFont(new Font("Dialog", 0, 12));
        this.lKMax.setText("Maximum Model Size:");
        this.pParameters.add((Component)this.lKMax, new AbsoluteConstraints(10, 60, 170, -1));
        this.pParameters.add((Component)this.tKMax, new AbsoluteConstraints(230, 60, 70, -1));
        this.lPenalty.setFont(new Font("Dialog", 0, 12));
        this.lPenalty.setText("Prior Mean P Parameter:");
        this.pParameters.add((Component)this.lPenalty, new AbsoluteConstraints(10, 80, 170, -1));
        this.pParameters.add((Component)this.tPenalty, new AbsoluteConstraints(230, 80, 70, -1));
        this.lNBest.setFont(new Font("Dialog", 0, 12));
        this.lNBest.setText("Number Of Best Models:");
        this.pParameters.add((Component)this.lNBest, new AbsoluteConstraints(10, 100, 220, -1));
        this.pParameters.add((Component)this.tNBest, new AbsoluteConstraints(230, 100, 70, -1));
        this.lInnerAnneal1.setFont(new Font("Dialog", 0, 12));
        this.lInnerAnneal1.setText("Annealing Parameter(replace) :");
        this.pParameters.add((Component)this.lInnerAnneal1, new AbsoluteConstraints(10, 140, 220, -1));
        this.pParameters.add((Component)this.tInnerAnneal1, new AbsoluteConstraints(230, 140, 70, -1));
        this.lInnerAnneal2.setFont(new Font("Dialog", 0, 12));
        this.lInnerAnneal2.setText("Annealing Parameter(delete) :");
        this.pParameters.add((Component)this.lInnerAnneal2, new AbsoluteConstraints(10, 160, 220, -1));
        this.pParameters.add((Component)this.tInnerAnneal2, new AbsoluteConstraints(230, 160, 70, -1));
        this.lInnerAnneal3.setFont(new Font("Dialog", 0, 12));
        this.lInnerAnneal3.setText("Annealing Parameter(add) :");
        this.pParameters.add((Component)this.lInnerAnneal3, new AbsoluteConstraints(10, 180, 220, -1));
        this.pParameters.add((Component)this.tInnerAnneal3, new AbsoluteConstraints(230, 180, 70, -1));
        this.lOuterAnneal.setFont(new Font("Dialog", 0, 12));
        this.lOuterAnneal.setText("Annealing Parameter(outer) :");
        this.pParameters.add((Component)this.lOuterAnneal, new AbsoluteConstraints(10, 200, 220, -1));
        this.pParameters.add((Component)this.tOuterAnneal, new AbsoluteConstraints(230, 200, 70, -1));
        this.lNIter.setFont(new Font("Dialog", 0, 12));
        this.lNIter.setText("Number Of Iterations:");
        this.pParameters.add((Component)this.lNIter, new AbsoluteConstraints(10, 120, 220, -1));
        this.pParameters.add((Component)this.tNIter, new AbsoluteConstraints(230, 120, 70, -1));
        this.getContentPane().add((Component)this.pParameters, new AbsoluteConstraints(10, 280, 310, 250));
        this.pOutput.setLayout((LayoutManager)new AbsoluteLayout());
        this.pOutput.setBorder(new TitledBorder(null, "Output", 0, 0, new Font("Dialog", 1, 11)));
        this.lOutFile.setFont(new Font("Dialog", 0, 12));
        this.lOutFile.setText("Models File:");
        this.pOutput.add((Component)this.lOutFile, new AbsoluteConstraints(10, 20, 150, -1));
        this.pOutput.add((Component)this.tOutFile, new AbsoluteConstraints(160, 20, 200, -1));
        this.OutFileButton.setFont(new Font("Dialog", 0, 12));
        this.OutFileButton.setText(" ...");
        this.OutFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.OutFileButtonActionPerformed(evt);
            }
        });
        this.pOutput.add((Component)this.OutFileButton, new AbsoluteConstraints(360, 20, 20, 20));
        this.lIterFile.setFont(new Font("Dialog", 0, 12));
        this.lIterFile.setText("Iteration Log File:");
        this.pOutput.add((Component)this.lIterFile, new AbsoluteConstraints(10, 40, 150, -1));
        this.pOutput.add((Component)this.tIterFile, new AbsoluteConstraints(160, 40, 200, -1));
        this.IterFileButton.setFont(new Font("Dialog", 0, 12));
        this.IterFileButton.setText(" ...");
        this.IterFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.IterFileButtonActionPerformed(evt);
            }
        });
        this.pOutput.add((Component)this.IterFileButton, new AbsoluteConstraints(360, 40, 20, 20));
        this.lSummaryFile.setFont(new Font("Dialog", 0, 12));
        this.lSummaryFile.setText("Model Summary File:");
        this.pOutput.add((Component)this.lSummaryFile, new AbsoluteConstraints(10, 60, 150, -1));
        this.pOutput.add((Component)this.tSummaryFile, new AbsoluteConstraints(160, 60, 200, -1));
        this.SummaryFileButton.setFont(new Font("Dialog", 0, 12));
        this.SummaryFileButton.setText(" ...");
        this.SummaryFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.SummaryFileButtonActionPerformed(evt);
            }
        });
        this.pOutput.add((Component)this.SummaryFileButton, new AbsoluteConstraints(360, 60, 20, 20));
        this.NoisyCheckBox.setFont(new Font("Dialog", 0, 12));
        this.NoisyCheckBox.setSelected(true);
        this.NoisyCheckBox.setText("Output debug information to standard output");
        this.pOutput.add((Component)this.NoisyCheckBox, new AbsoluteConstraints(10, 80, 370, -1));
        this.getContentPane().add((Component)this.pOutput, new AbsoluteConstraints(10, 166, 390, 110));
        this.LoadButton.setText("Load");
        this.LoadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.LoadButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.LoadButton, new AbsoluteConstraints(330, 300, 100, -1));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.OKButton, new AbsoluteConstraints(330, 460, 100, -1));
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.CancelButton, new AbsoluteConstraints(330, 500, 100, -1));
        this.RunButton.setText("Run");
        this.RunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.RunButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.RunButton, new AbsoluteConstraints(330, 380, 100, -1));
        this.StopButton.setText("Stop");
        this.StopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.StopButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.StopButton, new AbsoluteConstraints(330, 420, 100, -1));
        this.SaveButton.setText("Save");
        this.SaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModelDialog.this.SaveButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.SaveButton, new AbsoluteConstraints(330, 340, 100, -1));
        this.pack();
    }

    private void CensorshipFileButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        this.tCensorshipFile.setText(f.getName());
    }

    private void tWeightFileActionPerformed(ActionEvent evt) {
    }

    private void StopButtonActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec("killprocess.exe \"" + this.m.getModelSearchProgram() + "\"");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void RunButtonActionPerformed(ActionEvent evt) {
        if (!this.validateInput()) {
            return;
        }
        if (this.mstrModelFile.length() == 0) {
            File f = this.saveFileDialog();
            if (f == null) {
                return;
            }
            if (this.m != null) {
                this.m.save(f.getName());
            }
            this.mstrModelFile = f.getName();
        } else if (this.m != null) {
            this.m.save(this.mstrModelFile);
        }
        this.StopButton.setEnabled(true);
        this.RunButton.setEnabled(false);
        this.repaint();
        if (this.useMatlab) {
            try {
                MyObserver obs = new MyObserver(0);
                this.matlab.evalConsoleOutput("!" + this.m.getModelSearchProgram() + " \"" + this.m.getSettingFile() + "\"", (CompletionObserver)obs);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.toString());
            }
        } else {
            this.m.runSearch();
            this.StopButton.setEnabled(false);
            this.RunButton.setEnabled(true);
        }
    }

    private void SaveButtonActionPerformed(ActionEvent evt) {
        if (!this.validateInput()) {
            return;
        }
        File f = this.saveFileDialog();
        if (f == null) {
            return;
        }
        if (this.m != null) {
            this.m.save(f.getName());
        }
        this.mstrModelFile = f.getName();
    }

    private void SummaryFileButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        this.tSummaryFile.setText(f.getName());
    }

    private void IterFileButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        this.tIterFile.setText(f.getName());
    }

    private void OutFileButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        this.tOutFile.setText(f.getName());
    }

    private void WeightFileButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        this.tWeightFile.setText(f.getName());
    }

    private void ResponseFileButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        this.tResponseFile.setText(f.getName());
    }

    private void DataFileButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        this.tDataFile.setText(f.getName());
    }

    private void ToggleCheckBox() {
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        if (!this.validateInput()) {
            return;
        }
        File f = this.saveFileDialog();
        if (f == null) {
            return;
        }
        if (this.m != null) {
            this.m.save(f.getName());
        }
        this.setVisible(false);
        this.dispose();
        if (!this.useMatlab) {
            System.exit(0);
        }
    }

    private void LoadButtonActionPerformed(ActionEvent evt) {
        File f = this.openFileDialog();
        if (f == null) {
            return;
        }
        if (this.m != null) {
            this.m.load(f.getName());
        }
        this.initValues();
        this.mstrModelFile = f.getName();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        if (!this.useMatlab) {
            System.exit(0);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        if (!this.useMatlab) {
            System.exit(0);
        }
    }

    public File openFileDialog() {
        JFileChooser fc = new JFileChooser(this.CurrentPath);
        fc.setDialogTitle("Open File...");
        fc.setFileSelectionMode(0);
        int choice = fc.showOpenDialog(null);
        if (choice != 0) {
            return null;
        }
        this.CurrentPath = fc.getSelectedFile().getParent();
        return fc.getSelectedFile();
    }

    private File saveFileDialog() {
        JFileChooser fc = new JFileChooser(this.CurrentPath);
        fc.setDialogTitle("Save File As...");
        fc.setFileHidingEnabled(false);
        fc.setFileSelectionMode(0);
        int choice = fc.showSaveDialog(null);
        if (choice != 0) {
            return null;
        }
        this.CurrentPath = fc.getSelectedFile().getParent();
        return fc.getSelectedFile();
    }

    public static void main(String[] args) {
        new ModelDialog(new JFrame(), true, null).show();
    }

    protected class MyObserver
    implements CompletionObserver {
        private int Task;

        public MyObserver(int n) {
            this.Task = n;
        }

        public void completed(int param, Object obj) {
            ModelDialog.this.StopButton.setEnabled(false);
            ModelDialog.this.RunButton.setEnabled(true);
            if (this.Task == 0) {
                try {
                    Runtime.getRuntime().exec("killprocess.exe \"" + ModelDialog.this.m.getModelSearchProgram() + "\"");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

