
javaaddpath 'sss.jar'
javaaddpath 'AbsoluteLayout.jar' 
javaaddpath 'dataframe.jar'
import dataframe.*;

% ----------
% Examples: N=50 variables and 117 samples.
% Weight file indicates a randomly selected 80 samples for
% model search and fitting, the rest being treated as validation
% samples to predict/assess model fit

% read in design data and weight (training, validation) indicator
x=load('xdata.txt'); [n,N]=size(x); x=x'; 
w=load('wdata.txt'); itrain=find(w==1); ivalid=find(w==0); 

% ----------
% Example:  Binary regression search
    y=load('ybinarydata.txt'); 
% now generate a model search file and run it using the GUI via: 
%   a = sss.Model; a.start
% or edit the file and run the code directly using:
    !modelsearch.exe binary.setup.txt
% or, you could used the 64bit version modelsearch64 binary.setup.txt from linux command line
% when complete, read in text file with model summary: here we use a dataframe function but you
% can just edit and read in the summary text file directly if you prefer 
    models = TextArray('binary.modelsummary.txt','default','NA',false); 
    models = models.data;  nm=size(models,1); 
    pm=models(:,2);pm=exp(pm-max(pm));pm=pm/sum(pm);pmax=max(models(:,1)); 
    scatter(1:nm,pm); xlabel('Model'); ylabel('Probability'); 
% and summarise ... see full details in the binarysummary.m script 
    k=nm; binarysummary      

% ----------
% Example:  Linear regression search
    y=load('ylineardata.txt'); 
%   a = sss.Model; a.start
% or 
    !modelsearch.exe linear.setup.txt
% now read in text file with model summary: 
    models = TextArray('linear.modelsummary.txt','default','NA',false); 
    models = models.data;  nm=size(models,1); 
    pm=models(:,2);pm=exp(pm-max(pm));pm=pm/sum(pm);pmax=max(models(:,1)); 
    scatter(1:nm,pm)
% and summarise ... see full details in the linearsummary.m script 
    k=nm; linearsummary      


% ----------
% Example:  Weibull regression search
    y=load('ysurvtimedata.txt'); r=load('relapsedata.txt'); 
%   a = sss.Model; a.start
% or 
    !modelsearch.exe survival.setup.txt  
% now read in text file with model summary: 
    models = TextArray('survival.modelsummary.txt','default','NA',false); 
    models = models.data;  nm=size(models,1); 
    pm=models(:,2);pm=exp(pm-max(pm));pm=pm/sum(pm);pmax=max(models(:,1)); 
    scatter(1:nm,pm)
% and summarise ... see full details in the survivalsummary.m script 
    k=nm; survivalsummary     
    
