
# Examples: N=50 variables and 117 samples.
# Weight file indicates a randomly selected 80 samples for
# model search and fitting, the rest being treated as validation
# samples to predict/assess model fit

# set your working directory here:
setwd("C:\\SSS")
source("showtv.r"); source("show.r"); source("scattertv.r")

# read in design data and weight (training, validation) indicator
x <- as.matrix(read.table("xdata.txt"))
n <- dim(x)[1]; N <- dim(x)[2]
x <- t(x)
w <- as.matrix(read.table("wdata.txt"))
itrain <- (1:n)[w==1]; ivalid <- (1:n)[w==0]


# ----------
# Example:  Binary regression search
    y <- as.matrix(read.table("ybinarydata.txt")); 

# Now you will need to run SSS from the command line
# Next we'll read in and summarize the output files:
 
models <- as.matrix(read.table("modelsummary.txt"))
nm <- dim(models)[1]
pm <- models[,2]; pm <- exp(pm - max(pm)); pm <- pm/sum(pm)
pmax <- max(models[,1])
plot(pm, xlab="Model", ylab="Probability",pch=16,col="blue")
      
# and summarise ... see full details in the binarysummary.r script 
k <- nm
source("binarysummary.r")


# ----------
# Example:  Linear regression search
    y<-read.table("ylineardata.txt"); 

# Now you will need to run SSS from the command line
# Next we'll read in and summarize the output files:

# now read in text file with model summary: 
    models <- as.matrix(read.table("modelsummary.txt")) 
    nm <- dim(models)[1]
    pm <- models[,2]; pm <- exp(pm - max(pm)); pm <- pm/sum(pm)
    pmax <- max(models[,1]) 
    plot(pm, xlab="Model", ylab="Probability",pch=16,col="blue")
# and summarise ... see full details in the linearsummary.m script 
    k<-nm;
    source("linearsummary.r")